/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.StdRestxRequestMatch;
import restx.endpoint.Endpoint;

public class StdRestxRequestMatcher
implements RestxRequestMatcher {
    private final Endpoint endpoint;
    private final String stdPathPattern;
    private final Pattern pattern;
    private final ImmutableList<String> groupNames;
    private static final PathParserCharProcessor regularCharPathParserCharProcessor = new PathParserCharProcessor(){

        @Override
        public void handle(int curChar, PathPatternParser pathPatternParser) {
            if (curChar == 123) {
                pathPatternParser.processor = new CurlyBracesPathParamPathParserCharProcessor();
            } else if (curChar == 58) {
                pathPatternParser.processor = new SimpleColumnBasedPathParamParserCharProcessor();
            } else {
                pathPatternParser.patternBuilder.appendCodePoint(curChar);
                pathPatternParser.stdPathPatternBuilder.appendCodePoint(curChar);
            }
        }

        @Override
        public void end(PathPatternParser pathPatternParser) {
        }
    };

    public StdRestxRequestMatcher(Endpoint endpoint) {
        this.endpoint = endpoint;
        PathPatternParser s = new PathPatternParser(endpoint.getPathPattern());
        s.parse();
        this.pattern = Pattern.compile(s.patternBuilder.toString());
        this.stdPathPattern = s.stdPathPatternBuilder.toString();
        this.groupNames = s.groupNamesBuilder.build();
    }

    public StdRestxRequestMatcher(String method, String pathPattern) {
        this(new Endpoint(method, pathPattern));
    }

    @Override
    public Optional<? extends RestxRequestMatch> match(String method, String path) {
        if (!this.endpoint.getMethod().equals(method)) {
            return Optional.absent();
        }
        Matcher m = this.pattern.matcher(path);
        if (!m.matches()) {
            return Optional.absent();
        }
        ImmutableMap.Builder params = ImmutableMap.builder();
        for (int i = 0; i < m.groupCount() && i < this.groupNames.size(); ++i) {
            params.put((Object)((String)this.groupNames.get(i)), (Object)m.group(i + 1));
        }
        return Optional.of((Object)new StdRestxRequestMatch(this.endpoint.getPathPattern(), path, (ImmutableMap<String, String>)params.build()));
    }

    public String toString() {
        return this.endpoint.toString();
    }

    public String getMethod() {
        return this.endpoint.getMethod();
    }

    public String getPathPattern() {
        return this.endpoint.getPathPattern();
    }

    public String getStdPathPattern() {
        return this.stdPathPattern;
    }

    public ImmutableList<String> getPathParamNames() {
        return this.groupNames;
    }

    private static boolean isValidPathParamNameChar(int curChar) {
        return Character.isLetterOrDigit(curChar) || curChar == 95;
    }

    private static final class PathPatternParser {
        final int length;
        final String pathPattern;
        int offset = 0;
        PathParserCharProcessor processor = regularCharPathParserCharProcessor;
        ImmutableList.Builder<String> groupNamesBuilder = ImmutableList.builder();
        StringBuilder patternBuilder = new StringBuilder();
        StringBuilder stdPathPatternBuilder = new StringBuilder();

        private PathPatternParser(String pathPattern) {
            this.length = pathPattern.length();
            this.pathPattern = pathPattern;
        }

        void parse() {
            while (this.offset < this.length) {
                int curChar = this.pathPattern.codePointAt(this.offset);
                this.processor.handle(curChar, this);
                this.offset += Character.charCount(curChar);
            }
            this.processor.end(this);
        }
    }

    private static interface PathParserCharProcessor {
        public void handle(int var1, PathPatternParser var2);

        public void end(PathPatternParser var1);
    }

    private static final class SimpleColumnBasedPathParamParserCharProcessor
    implements PathParserCharProcessor {
        private StringBuilder pathParamName = new StringBuilder();

        private SimpleColumnBasedPathParamParserCharProcessor() {
        }

        @Override
        public void handle(int curChar, PathPatternParser pathPatternParser) {
            if (!StdRestxRequestMatcher.isValidPathParamNameChar(curChar)) {
                pathPatternParser.patternBuilder.append("([^\\/]+)");
                pathPatternParser.stdPathPatternBuilder.append("{").append((CharSequence)this.pathParamName).append("}");
                pathPatternParser.groupNamesBuilder.add((Object)this.pathParamName.toString());
                pathPatternParser.processor = regularCharPathParserCharProcessor;
                pathPatternParser.processor.handle(curChar, pathPatternParser);
            } else {
                this.pathParamName.appendCodePoint(curChar);
            }
        }

        @Override
        public void end(PathPatternParser pathPatternParser) {
            pathPatternParser.patternBuilder.append("([^\\/]+)");
            pathPatternParser.stdPathPatternBuilder.append("{").append((CharSequence)this.pathParamName).append("}");
            pathPatternParser.groupNamesBuilder.add((Object)this.pathParamName.toString());
        }
    }

    private static final class CurlyBracesPathParamPathParserCharProcessor
    implements PathParserCharProcessor {
        private int openBr = 1;
        private boolean inRegexDef;
        private StringBuilder pathParamName = new StringBuilder();
        private StringBuilder pathParamRegex = new StringBuilder();

        private CurlyBracesPathParamPathParserCharProcessor() {
        }

        @Override
        public void handle(int curChar, PathPatternParser pathPatternParser) {
            if (curChar == 125) {
                --this.openBr;
                if (this.openBr == 0) {
                    if (this.pathParamName.length() == 0) {
                        pathPatternParser.processor = regularCharPathParserCharProcessor;
                        pathPatternParser.patternBuilder.append("{}");
                        pathPatternParser.stdPathPatternBuilder.append("{}");
                        return;
                    }
                    if (this.pathParamRegex.length() == 1) {
                        throw new IllegalArgumentException(String.format("illegal path parameter definition '%s' at offset %d - custom regex must not be empty", pathPatternParser.pathPattern, pathPatternParser.offset));
                    }
                    if (this.pathParamRegex.length() == 0) {
                        this.pathParamRegex.append("([^\\/]+)");
                    } else {
                        this.pathParamRegex.append(")");
                    }
                    pathPatternParser.processor = regularCharPathParserCharProcessor;
                    pathPatternParser.patternBuilder.append((CharSequence)this.pathParamRegex);
                    pathPatternParser.stdPathPatternBuilder.append("{").append((CharSequence)this.pathParamName).append("}");
                    pathPatternParser.groupNamesBuilder.add((Object)this.pathParamName.toString());
                    return;
                }
            } else if (curChar == 123) {
                ++this.openBr;
            }
            if (this.inRegexDef) {
                this.pathParamRegex.appendCodePoint(curChar);
            } else if (curChar == 58) {
                this.inRegexDef = true;
                this.pathParamRegex.append("(");
            } else {
                if (!StdRestxRequestMatcher.isValidPathParamNameChar(curChar)) {
                    throw new IllegalArgumentException(String.format("illegal path parameter definition '%s' at offset %d - only letters and digits are authorized in path param name", pathPatternParser.pathPattern, pathPatternParser.offset));
                }
                this.pathParamName.appendCodePoint(curChar);
            }
        }

        @Override
        public void end(PathPatternParser pathPatternParser) {
        }
    }
}

