/*
 * Decompiled with CFR 0.152.
 */
package restx.endpoint;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.endpoint.EndpointParamDef;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EndpointParameterKind {
    QUERY{

        @Override
        public Optional<String> extractQueryParamStringedValueFor(EndpointParamDef parameter, RestxRequest request, RestxRequestMatch match) {
            return request.getQueryParam(parameter.getName());
        }

        @Override
        public List<String> extractQueryParamStringedValuesFor(EndpointParamDef parameter, RestxRequest request, RestxRequestMatch match) {
            return request.getQueryParams(parameter.getName());
        }
    }
    ,
    PATH{

        @Override
        public Optional<String> extractQueryParamStringedValueFor(EndpointParamDef parameter, RestxRequest request, RestxRequestMatch match) {
            return Optional.of((Object)match.getPathParam(parameter.getName()));
        }

        @Override
        public List<String> extractQueryParamStringedValuesFor(EndpointParamDef parameter, RestxRequest request, RestxRequestMatch match) {
            return (List)this.extractQueryParamStringedValueFor(parameter, request, match).transform((Function)new Function<String, List<String>>(){

                public List<String> apply(String pathParam) {
                    return Lists.newArrayList((Object[])new String[]{pathParam});
                }
            }).or(Collections.emptyList());
        }
    }
    ,
    HEADER{

        @Override
        public Optional<String> extractQueryParamStringedValueFor(EndpointParamDef parameter, RestxRequest request, RestxRequestMatch match) {
            return request.getHeader(parameter.getName());
        }

        @Override
        public List<String> extractQueryParamStringedValuesFor(EndpointParamDef parameter, RestxRequest request, RestxRequestMatch match) {
            return (List)this.extractQueryParamStringedValueFor(parameter, request, match).transform((Function)new Function<String, List<String>>(){

                public List<String> apply(String headerParam) {
                    return Lists.newArrayList((Object[])new String[]{headerParam});
                }
            }).or(Collections.emptyList());
        }
    };


    public abstract Optional<String> extractQueryParamStringedValueFor(EndpointParamDef var1, RestxRequest var2, RestxRequestMatch var3);

    public abstract List<String> extractQueryParamStringedValuesFor(EndpointParamDef var1, RestxRequest var2, RestxRequestMatch var3);
}

