/*
 * Decompiled with CFR 0.152.
 */
package restx.endpoint;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import restx.endpoint.EndpointParamDef;
import restx.endpoint.mappers.EndpointParameterMapper;
import restx.endpoint.mappers.EndpointParameterMapperFactory;
import restx.factory.Component;

@Component
public class EndpointParameterMapperRegistry {
    private final Iterable<EndpointParameterMapperFactory> factories;

    public EndpointParameterMapperRegistry(Iterable<EndpointParameterMapperFactory> factories) {
        this.factories = factories;
    }

    public <T> EndpointParameterMapper getEndpointParameterMapperFor(EndpointParamDef endpointParamDef) {
        for (EndpointParameterMapperFactory factory : this.factories) {
            Optional<? extends EndpointParameterMapper> mapper = factory.getEndpointParameterMapperFor(endpointParamDef);
            if (!mapper.isPresent()) continue;
            return (EndpointParameterMapper)mapper.get();
        }
        throw new IllegalStateException(String.format("no mapper found for parameter %s !%nAvailable factories: %s", new Object[]{endpointParamDef, Iterables.toString(this.factories)}));
    }
}

