/*
 * Decompiled with CFR 0.152.
 */
package restx.jackson;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Set;
import javax.inject.Named;
import restx.AppSettings;
import restx.factory.Factory;
import restx.factory.Name;
import restx.factory.Provides;
import restx.jackson.Views;

@restx.factory.Module
public class FrontObjectMapperFactory {
    public static final String MAPPER_NAME = "FrontObjectMapper";
    public static final Name<ObjectMapper> NAME = Name.of(ObjectMapper.class, (String)"FrontObjectMapper");
    public static final String WRITER_NAME = "FrontObjectWriter";
    public static final String READER_NAME = "FrontObjectReader";

    @Named(value="FrontObjectMapper")
    @Provides
    public ObjectMapper mapper(final Factory factory) {
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JodaModule()).registerModule((Module)new GuavaModule()).registerModule((Module)new JavaTimeModule()).setDefaultPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"))).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.EAGER_DESERIALIZER_FETCH).disable(SerializationFeature.EAGER_SERIALIZER_FETCH);
        Set modules = factory.getComponents(Module.class);
        mapper.registerModules((Iterable)modules);
        mapper.setHandlerInstantiator(new HandlerInstantiator(){

            public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
                return (JsonDeserializer)factory.queryByClass(deserClass).optional().findOneAsComponent().orNull();
            }

            public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
                return (KeyDeserializer)factory.queryByClass(keyDeserClass).optional().findOneAsComponent().orNull();
            }

            public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
                return (JsonSerializer)factory.queryByClass(serClass).optional().findOneAsComponent().orNull();
            }

            public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
                return (TypeResolverBuilder)factory.queryByClass(builderClass).optional().findOneAsComponent().orNull();
            }

            public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
                return (TypeIdResolver)factory.queryByClass(resolverClass).optional().findOneAsComponent().orNull();
            }
        });
        return mapper;
    }

    @Named(value="FrontObjectWriter")
    @Provides
    public ObjectWriter objectWriter(@Named(value="FrontObjectMapper") ObjectMapper mapper, AppSettings appSettings) {
        ObjectWriter objectWriter = "prod".equals(appSettings.mode()) ? mapper.writer() : mapper.writerWithDefaultPrettyPrinter();
        return objectWriter.withView(Views.Transient.class);
    }

    @Named(value="FrontObjectReader")
    @Provides
    public ObjectReader objectReader(@Named(value="FrontObjectMapper") ObjectMapper mapper) {
        return mapper.readerWithView(Views.Transient.class);
    }
}

