/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxContext;
import restx.RestxFilter;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.StdRestxRequestMatch;
import restx.factory.Component;
import restx.security.AcceptedCORS;
import restx.security.CORS;
import restx.security.CORSAuthorizer;
import restx.security.CORSHandler;

@Component
public class CORSFilter
extends CORSHandler
implements RestxFilter,
RestxHandler {
    private static final Logger logger = LoggerFactory.getLogger(CORSFilter.class);
    private static final Collection<String> SIMPLE_METHODS = Arrays.asList("GET", "HEAD", "POST");
    private final Iterable<CORSAuthorizer> authorizers;

    public CORSFilter(Iterable<CORSAuthorizer> authorizers) {
        this.authorizers = authorizers;
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRequest req) {
        Optional<String> origin = req.getHeader("Origin");
        if (origin.isPresent() && !this.isSameOrigin(req, (String)origin.get()) && !this.isPreflightRequest(req)) {
            CORS cors = CORS.check(this.authorizers, req, (String)origin.get(), req.getHttpMethod(), req.getRestxPath());
            if (cors.isAccepted()) {
                return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("*", req.getRestxPath(), (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableMap<String, ? extends Object>)ImmutableMap.of((Object)"cors", (Object)cors)), this));
            }
            if (this.isSimpleCORSRequest(req)) {
                logger.info("Unauthorized simple CORS request; Origin={}; Method={}", origin.get(), (Object)req.getHttpMethod());
            } else {
                logger.info("Unauthorized CORS request (not captured by pre flight); Origin={}; Method={}", origin.get(), (Object)req.getHttpMethod());
            }
            return this.unauthorized(req);
        }
        return Optional.absent();
    }

    private boolean isPreflightRequest(RestxRequest req) {
        return req.getHeader("Origin").isPresent() && req.getHeader("Access-Control-Request-Method").isPresent() && "OPTIONS".equals(req.getHttpMethod());
    }

    protected boolean isSimpleCORSRequest(RestxRequest req) {
        if (!SIMPLE_METHODS.contains(req.getHttpMethod())) {
            return false;
        }
        Optional<String> origin = req.getHeader("Origin");
        if (!origin.isPresent()) {
            return false;
        }
        return !"POST".equals(req.getHttpMethod()) || Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain").contains(req.getContentType());
    }

    private boolean isSameOrigin(RestxRequest req, String origin) {
        Optional<String> host = req.getHeader("Host");
        if (!host.isPresent()) {
            return false;
        }
        if (origin.endsWith((String)host.get())) {
            logger.debug("Same Origin request not considered as CORS Request: {}", (Object)req);
            return true;
        }
        return false;
    }

    @Override
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        AcceptedCORS cors = (AcceptedCORS)match.getOtherParams().get((Object)"cors");
        resp.setHeader("Access-Control-Allow-Origin", cors.getOrigin());
        if (!cors.getHeaders().isEmpty()) {
            resp.setHeader("Access-Control-Allow-Headers", Joiner.on((String)", ").join(cors.getHeaders()));
        }
        if (!cors.getMethods().isEmpty()) {
            resp.setHeader("Access-Control-Allow-Methods", Joiner.on((String)", ").join(cors.getMethods()));
        }
        if (((Boolean)cors.getAllowCredentials().or((Object)false)).booleanValue()) {
            resp.setHeader("Access-Control-Allow-Credentials", "true");
        }
        ctx.nextHandlerMatch().handle(req, resp, ctx);
    }

    public String toString() {
        return "CORSFilter";
    }
}

