/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.StdRestxRequestMatch;
import restx.factory.Component;
import restx.security.AcceptedCORS;
import restx.security.CORS;
import restx.security.CORSAuthorizer;
import restx.security.CORSHandler;

@Component
public class CORSRoute
extends CORSHandler
implements RestxRoute,
RestxHandler {
    private static final Logger logger = LoggerFactory.getLogger(CORSRoute.class);
    private final Iterable<CORSAuthorizer> authorizers;

    public CORSRoute(Iterable<CORSAuthorizer> authorizers) {
        this.authorizers = authorizers;
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRequest req) {
        Optional<String> acrMethod = req.getHeader("Access-Control-Request-Method");
        if ("OPTIONS".equals(req.getHttpMethod()) && acrMethod.isPresent()) {
            Optional<String> origin = req.getHeader("Origin");
            CORS cors = CORS.check(this.authorizers, req, (String)origin.get(), (String)acrMethod.get(), req.getRestxPath());
            if (cors.isAccepted()) {
                return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("*", req.getRestxPath(), (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableMap<String, ? extends Object>)ImmutableMap.of((Object)"cors", (Object)cors)), this));
            }
            logger.info("Unauthorized pre-flight CORS request; Origin={}; Method={}", origin.get(), acrMethod.get());
            return this.unauthorized(req);
        }
        return Optional.absent();
    }

    @Override
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        AcceptedCORS cors = (AcceptedCORS)match.getOtherParams().get((Object)"cors");
        resp.setHeader("Access-Control-Allow-Origin", cors.getOrigin());
        if (!cors.getHeaders().isEmpty()) {
            resp.setHeader("Access-Control-Allow-Headers", Joiner.on((String)", ").join(cors.getHeaders()));
        }
        if (!cors.getMethods().isEmpty()) {
            resp.setHeader("Access-Control-Allow-Methods", Joiner.on((String)", ").join(cors.getMethods()));
        }
        if (((Boolean)cors.getAllowCredentials().or((Object)false)).booleanValue()) {
            resp.setHeader("Access-Control-Allow-Credentials", "true");
        }
        resp.setHeader("Access-Control-Max-Age", String.valueOf(cors.getMaxAge()));
    }

    public String toString() {
        return "CORSRoute";
    }
}

