/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import restx.factory.Component;
import restx.security.Permission;
import restx.security.RestxPrincipal;

@Component
public class PermissionFactory {
    private static final Pattern ROLE_PARAM_INTERPOLATOR_REGEX = Pattern.compile("\\{(.+?)\\}");
    private static final Permission OPEN = new Permission(){

        @Override
        public Optional<? extends Permission> has(RestxPrincipal principal, Map<String, String> roleInterpolationMap) {
            return Optional.of((Object)this);
        }

        public String toString() {
            return "OPEN";
        }
    };
    private static final Permission IS_AUTHENTICATED = new Permission(){

        @Override
        public Optional<? extends Permission> has(RestxPrincipal principal, Map<String, String> roleInterpolationMap) {
            return Optional.of((Object)this);
        }

        public String toString() {
            return "IS_AUTHENTICATED";
        }
    };

    public Permission open() {
        return OPEN;
    }

    public Permission isAuthenticated() {
        return IS_AUTHENTICATED;
    }

    public boolean isOpen(Permission permission) {
        return permission == this.open();
    }

    public boolean isIsAuthenticated(Permission permission) {
        return permission == this.isAuthenticated();
    }

    public Permission hasRole(final String role) {
        return new Permission(){
            public final String TO_STRING;
            {
                this.TO_STRING = "HAS_ROLE[" + role + "]";
            }

            @Override
            public Optional<? extends Permission> has(RestxPrincipal principal, Map<String, String> roleInterpolationMap) {
                if (principal.getPrincipalRoles().contains((Object)"*")) {
                    return Optional.of((Object)this);
                }
                String interpolatedRole = PermissionFactory.this.interpolateRole(role, roleInterpolationMap);
                if (principal.getPrincipalRoles().contains((Object)interpolatedRole)) {
                    return Optional.of((Object)this);
                }
                return Optional.absent();
            }

            public String toString() {
                return this.TO_STRING;
            }
        };
    }

    protected String interpolateRole(String role, Map<String, String> roleInterpolationMap) {
        Matcher matcher = ROLE_PARAM_INTERPOLATOR_REGEX.matcher(role);
        StringBuffer interpolatedRole = new StringBuffer();
        while (matcher.find()) {
            String interpolationVarName = matcher.group(1);
            if (!roleInterpolationMap.containsKey(interpolationVarName)) {
                throw new IllegalArgumentException(String.format("Variable <%s> not found in role interpolation map <%s>", interpolationVarName, roleInterpolationMap.toString()));
            }
            matcher.appendReplacement(interpolatedRole, roleInterpolationMap.get(interpolationVarName));
        }
        matcher.appendTail(interpolatedRole);
        return interpolatedRole.toString();
    }

    public Permission anyOf(final Permission ... permissions) {
        return new Permission(){

            @Override
            public Optional<? extends Permission> has(RestxPrincipal principal, Map<String, String> roleInterpolationMap) {
                for (Permission permission : permissions) {
                    Optional<? extends Permission> p = permission.has(principal, roleInterpolationMap);
                    if (!p.isPresent()) continue;
                    return p;
                }
                return Optional.absent();
            }

            public String toString() {
                return "ANY_OF[" + Arrays.toString(permissions) + "]";
            }
        };
    }

    public Permission allOf(final Permission ... permissions) {
        return new Permission(){

            @Override
            public Optional<? extends Permission> has(RestxPrincipal principal, Map<String, String> roleInterpolationMap) {
                for (Permission permission : permissions) {
                    Optional<? extends Permission> p = permission.has(principal, roleInterpolationMap);
                    if (p.isPresent()) continue;
                    return Optional.absent();
                }
                return Optional.of((Object)this);
            }

            public String toString() {
                return "ALL_OF[" + Arrays.toString(permissions) + "]";
            }
        };
    }
}

