/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.joda.time.Duration;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.StdRestxRequestMatch;
import restx.factory.Component;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;

@Component(priority=-199)
public class RestxSessionBareFilter
implements RestxRouteFilter,
RestxHandler {
    private final RestxSession.Definition definition;

    public RestxSessionBareFilter(RestxSession.Definition definition) {
        this.definition = definition;
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRoute route) {
        return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("/*"), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        boolean hasSetSession = false;
        if (RestxSession.current() == null) {
            RestxSession.setCurrent(new RestxSession(this.definition, (ImmutableMap<String, String>)ImmutableMap.of(), (Optional<? extends RestxPrincipal>)Optional.absent(), Duration.ZERO));
            hasSetSession = true;
        }
        try {
            ctx.nextHandlerMatch().handle(req, resp, ctx);
        }
        finally {
            if (hasSetSession) {
                RestxSession.setCurrent(null);
            }
        }
    }
}

