/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxRequest;
import restx.security.CORS;
import restx.security.CORSAuthorizer;

public class StdCORSAuthorizer
implements CORSAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(StdCORSAuthorizer.class);
    private final Predicate<CharSequence> originMatcher;
    private final Predicate<CharSequence> pathMatcher;
    private final ImmutableCollection<String> allowedMethods;
    private final ImmutableCollection<String> allowedHeaders;
    private final Optional<Boolean> allowCredentials;
    private final int maxAge;

    public static Builder builder() {
        return new Builder();
    }

    public StdCORSAuthorizer(Predicate<CharSequence> originMatcher, Predicate<CharSequence> pathMatcher, ImmutableCollection<String> allowedMethods, ImmutableCollection<String> allowedHeaders, Optional<Boolean> allowCredentials, int maxAge) {
        this.maxAge = maxAge;
        this.originMatcher = (Predicate)Preconditions.checkNotNull(originMatcher);
        this.pathMatcher = (Predicate)Preconditions.checkNotNull(pathMatcher);
        this.allowedMethods = (ImmutableCollection)Preconditions.checkNotNull(allowedMethods);
        this.allowedHeaders = (ImmutableCollection)Preconditions.checkNotNull(this.toLowerCase(allowedHeaders));
        this.allowCredentials = (Optional)Preconditions.checkNotNull(allowCredentials);
    }

    private ImmutableCollection<String> toLowerCase(ImmutableCollection<String> strings) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String string : strings) {
            builder.add((Object)string.toLowerCase(Locale.ENGLISH));
        }
        return builder.build();
    }

    @Override
    public Optional<CORS> checkCORS(RestxRequest request, String origin, String method, String restxPath) {
        if (this.originMatcher.apply((Object)origin) && this.pathMatcher.apply((Object)restxPath)) {
            if (!Iterables.contains(this.allowedMethods, (Object)method)) {
                logger.debug("CORS request not accepted by {}: method not allowed {}\nREQUEST => {}", new Object[]{this, method, request});
                return Optional.of((Object)CORS.reject());
            }
            if (!this.checkAllowed(request, "Access-Control-Request-Methods", this.allowedMethods)) {
                return Optional.of((Object)CORS.reject());
            }
            if (!this.checkAllowed(request, "Access-Control-Request-Headers", this.allowedHeaders)) {
                return Optional.of((Object)CORS.reject());
            }
            return Optional.of((Object)CORS.accept(origin, this.allowedMethods, this.allowedHeaders, this.allowCredentials, this.maxAge));
        }
        return Optional.absent();
    }

    private boolean checkAllowed(RestxRequest request, String headerName, ImmutableCollection<String> allowed) {
        Optional<String> requestProperty = request.getHeader(headerName);
        if (requestProperty.isPresent()) {
            for (String s : Splitter.on((char)',').trimResults().split((CharSequence)requestProperty.get())) {
                if (allowed.contains((Object)s.toLowerCase(Locale.ENGLISH))) continue;
                logger.debug("CORS request not accepted by {}: {} not allowed: {}\nREQUEST => {}", new Object[]{this, headerName, s, request});
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "StdCORSAuthorizer{originMatcher=" + this.originMatcher + ", pathMatcher=" + this.pathMatcher + ", allowedMethods=" + this.allowedMethods + ", allowedHeaders=" + this.allowedHeaders + ", allowCredentials=" + this.allowCredentials + "}";
    }

    public static class Builder {
        private Predicate<CharSequence> originMatcher = Predicates.alwaysTrue();
        private Predicate<CharSequence> pathMatcher = Predicates.alwaysTrue();
        private ImmutableCollection<String> allowedMethods = ImmutableSet.of((Object)"GET");
        private ImmutableCollection<String> allowedHeaders = ImmutableSet.of();
        private Optional<Boolean> allowCredentials = Optional.absent();
        private int maxAge = 1728000;

        public Builder setOriginMatcher(Predicate<CharSequence> originMatcher) {
            this.originMatcher = originMatcher;
            return this;
        }

        public Builder setPathMatcher(Predicate<CharSequence> pathMatcher) {
            this.pathMatcher = pathMatcher;
            return this;
        }

        public Builder setAllowedMethods(ImmutableCollection<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public Builder setAllowedHeaders(ImmutableCollection<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        public Builder setAllowCredentials(Optional<Boolean> allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public Builder setMaxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public StdCORSAuthorizer build() {
            return new StdCORSAuthorizer(this.originMatcher, this.pathMatcher, this.allowedMethods, this.allowedHeaders, this.allowCredentials, this.maxAge);
        }
    }
}

