/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.WebException;
import restx.factory.Component;
import restx.http.HttpStatus;
import restx.security.Permission;
import restx.security.PermissionFactory;
import restx.security.RestxPrincipal;
import restx.security.RestxSecurityManager;
import restx.security.RestxSession;

@Component
public class StdRestxSecurityManager
implements RestxSecurityManager {
    private static final Logger logger = LoggerFactory.getLogger(StdRestxSecurityManager.class);
    protected final PermissionFactory permissionFactory;

    public StdRestxSecurityManager(PermissionFactory permissionFactory) {
        this.permissionFactory = permissionFactory;
    }

    @Override
    public void check(RestxRequest request, RestxRequestMatch requestMatch, Permission permission) {
        if (this.permissionFactory.isOpen(permission)) {
            return;
        }
        Optional<? extends RestxPrincipal> principal = RestxSession.current().getPrincipal();
        if (!principal.isPresent()) {
            logger.debug("no principal found: request={}", (Object)request);
            throw new WebException(HttpStatus.UNAUTHORIZED);
        }
        Optional<? extends Permission> match = permission.has((RestxPrincipal)principal.get(), this.createRoleInterpolationMapFrom(request, requestMatch));
        if (match.isPresent()) {
            logger.debug("permission matched: request={} principal={} perm={}", new Object[]{request, principal.get(), match.get()});
            return;
        }
        logger.debug("permission not matched: request={} principal={} permission={}", new Object[]{request, principal.get(), permission});
        throw new WebException(HttpStatus.FORBIDDEN);
    }

    protected Map<String, String> createRoleInterpolationMapFrom(RestxRequest request, RestxRequestMatch match) {
        HashMap<String, String> roleInterpolationMap = new HashMap<String, String>();
        if (request != null) {
            roleInterpolationMap.putAll(Maps.transformValues(request.getQueryParams(), (Function)new Function<List<String>, String>(){

                public String apply(List<String> input) {
                    return (String)Iterables.getFirst(input, null);
                }
            }));
        }
        if (match != null) {
            roleInterpolationMap.putAll((Map<String, String>)match.getPathParams());
        }
        return roleInterpolationMap;
    }
}

