/*
 * Decompiled with CFR 0.152.
 */
package restx.server;

import java.util.concurrent.atomic.AtomicLong;
import restx.common.MoreFiles;
import restx.common.MoreIO;
import restx.common.Version;
import restx.server.WebServer;
import restx.server.WebServers;

public abstract class WebServerBase
implements WebServer {
    protected static final AtomicLong SERVER_ID = new AtomicLong();
    protected final int port;
    protected final String bindInterface;
    protected final String appBase;
    protected String serverId;
    protected final String serverTypeName;
    protected final String serverGroupId;
    protected final String serverModule;

    protected WebServerBase(String appBase, int port, String bindInterface, String serverTypeName, String serverGroupId, String serverModule) {
        if (appBase != null) {
            MoreFiles.checkFileExists((String)appBase);
        }
        this.port = port;
        this.bindInterface = bindInterface;
        this.appBase = appBase;
        this.serverId = serverTypeName + "#" + SERVER_ID.incrementAndGet();
        this.serverTypeName = serverTypeName;
        this.serverGroupId = serverGroupId;
        this.serverModule = serverModule;
    }

    public synchronized WebServerBase setServerId(String serverId) {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set server id when server is started");
        }
        this.serverId = serverId;
        return this;
    }

    @Override
    public String getServerType() {
        return this.serverTypeName + " " + Version.getVersion((String)this.serverGroupId, (String)this.serverModule) + ", embedded";
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String baseUrl() {
        return WebServers.baseUri("127.0.0.1", this.port);
    }

    @Override
    public synchronized void start() throws Exception {
        MoreIO.checkCanOpenSocket((int)this.port);
        WebServers.register(this);
        this._start();
    }

    @Override
    public void startAndAwait() throws Exception {
        this.start();
        this.await();
    }

    @Override
    public synchronized void stop() throws Exception {
        this._stop();
        WebServers.unregister(this.serverId);
    }

    @Override
    public synchronized boolean isStarted() {
        return WebServers.getServerById(this.serverId).isPresent();
    }

    @Override
    public abstract void await() throws InterruptedException;

    protected abstract void _start() throws Exception;

    protected abstract void _stop() throws Exception;
}

