/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.security.RestxSessionCookieFilter;
import restx.specs.Given;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecTape;

public class RestxSpecRecorder {
    private final Set<GivenRecorder> recorders;
    private final RestxSessionCookieFilter sessionFilter;
    private final RestxSpec.StorageSettings storageSettings;
    private final Repository repository;

    public RestxSpecRecorder(Set<GivenRecorder> recorders, RestxSessionCookieFilter sessionFilter, RestxSpec.StorageSettings storageSettings, Repository repository) {
        this.recorders = recorders;
        this.sessionFilter = sessionFilter;
        this.storageSettings = storageSettings;
        this.repository = repository;
    }

    public RestxSpecTape record(RestxRequest restxRequest, RestxResponse restxResponse, Optional<String> recordPath, Optional<String> recordTitle) throws IOException {
        return new RestxSpecTape(restxRequest, restxResponse, this.recorders, this.sessionFilter, this.storageSettings).doRecord(recordPath, recordTitle);
    }

    public RecordedSpec stop(RestxSpecTape tape) {
        RecordedSpec recordedSpec = tape.close();
        this.repository.add(recordedSpec);
        return recordedSpec;
    }

    public static class Repository {
        private final List<RecordedSpec> recordedSpecs = new CopyOnWriteArrayList<RecordedSpec>();

        public List<RecordedSpec> getRecordedSpecs() {
            return this.recordedSpecs;
        }

        public void add(RecordedSpec recordedSpec) {
            this.recordedSpecs.add(recordedSpec);
        }
    }

    public static class RecordedSpec {
        private RestxSpec spec;
        private DateTime recordTime;
        private Duration duration;
        private int capturedItems;
        private int capturedRequestSize;
        private int capturedResponseSize;
        private int id;
        private String path;
        private String method;

        public RecordedSpec setSpec(RestxSpec spec) {
            this.spec = spec;
            return this;
        }

        public RecordedSpec setRecordTime(DateTime recordTime) {
            this.recordTime = recordTime;
            return this;
        }

        public RecordedSpec setDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public RecordedSpec setCapturedItems(int capturedItems) {
            this.capturedItems = capturedItems;
            return this;
        }

        public RecordedSpec setCapturedRequestSize(int capturedRequestSize) {
            this.capturedRequestSize = capturedRequestSize;
            return this;
        }

        public RecordedSpec setCapturedResponseSize(int capturedResponseSize) {
            this.capturedResponseSize = capturedResponseSize;
            return this;
        }

        public RestxSpec getSpec() {
            return this.spec;
        }

        public DateTime getRecordTime() {
            return this.recordTime;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public int getCapturedItems() {
            return this.capturedItems;
        }

        public int getCapturedRequestSize() {
            return this.capturedRequestSize;
        }

        public int getCapturedResponseSize() {
            return this.capturedResponseSize;
        }

        public int getId() {
            return this.id;
        }

        public RecordedSpec setId(int id) {
            this.id = id;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public String getMethod() {
            return this.method;
        }

        public RecordedSpec setPath(String path) {
            this.path = path;
            return this;
        }

        public RecordedSpec setMethod(String method) {
            this.method = method;
            return this;
        }
    }

    public static interface GivenRecorder {
        public AutoCloseable recordIn(Map<String, Given> var1);
    }
}

