/*
 * Decompiled with CFR 0.152.
 */
package restx.factory.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import restx.common.Mustaches;
import restx.common.processor.RestxAbstractProcessor;
import restx.factory.Alternative;
import restx.factory.Component;
import restx.factory.Machine;
import restx.factory.Module;
import restx.factory.NamedComponent;
import restx.factory.Provides;
import restx.factory.When;

@SupportedAnnotationTypes(value={"restx.factory.Component", "restx.factory.Module", "restx.factory.Provides", "restx.factory.Alternative", "restx.factory.Machine"})
@SupportedOptions(value={"debug"})
public class FactoryAnnotationProcessor
extends RestxAbstractProcessor {
    final Template componentMachineTpl = Mustaches.compile(FactoryAnnotationProcessor.class, (String)"ComponentMachine.mustache");
    final Template conditionalMachineTpl = Mustaches.compile(FactoryAnnotationProcessor.class, (String)"ConditionalMachine.mustache");
    final Template moduleMachineTpl = Mustaches.compile(FactoryAnnotationProcessor.class, (String)"ModuleMachine.mustache");
    private final ServicesDeclaration machinesDeclaration = new ServicesDeclaration("restx.factory.FactoryMachine");

    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws IOException {
        this.machinesDeclaration.processing();
        if (roundEnv.processingOver()) {
            this.machinesDeclaration.generate();
        } else {
            this.processComponents(roundEnv);
            this.processAlternatives(roundEnv);
            this.processModules(roundEnv);
            this.processMachines(roundEnv);
        }
        return true;
    }

    private void processModules(RoundEnvironment roundEnv) throws IOException {
        for (Element element : roundEnv.getElementsAnnotatedWith(Module.class)) {
            try {
                if (!(element instanceof TypeElement)) {
                    this.error("annotating element " + element + " of type " + element.getKind().name() + " with @Module is not supported", element);
                    continue;
                }
                TypeElement typeElem = (TypeElement)element;
                Module mod = typeElem.getAnnotation(Module.class);
                When classWhen = typeElem.getAnnotation(When.class);
                ModuleClass module = new ModuleClass(typeElem.getQualifiedName().toString(), typeElem, mod.priority());
                for (Element element2 : typeElem.getEnclosedElements()) {
                    When whenToUse;
                    Provides provides = element2.getAnnotation(Provides.class);
                    Alternative alternative = element2.getAnnotation(Alternative.class);
                    if (!(element2 instanceof ExecutableElement) || element2.getKind() != ElementKind.METHOD) continue;
                    ExecutableElement exec = (ExecutableElement)element2;
                    When methodWhen = exec.getAnnotation(When.class);
                    if (provides != null && methodWhen == null && classWhen == null) {
                        this.processProviderMethod(mod, module, provides, exec);
                        continue;
                    }
                    if (classWhen != null) {
                        if (methodWhen != null) {
                            this.error("the module class is annotated with @When, so methods are not allowed to be annotated with @When", exec);
                            continue;
                        }
                        whenToUse = classWhen;
                    } else {
                        whenToUse = methodWhen;
                    }
                    if (provides != null) {
                        this.processConditionalProviderMethod(mod, module, exec.getReturnType().toString(), (String)this.getInjectionName(exec.getAnnotation(Named.class)).or((Object)exec.getSimpleName().toString()), provides.priority() == 0 ? mod.priority() : provides.priority(), whenToUse, "Conditional", exec);
                        continue;
                    }
                    if (alternative == null) continue;
                    if (whenToUse == null) {
                        this.error("an Alternative MUST be annotated with @When to tell when it must be activated, or the whole module must be annotated with @When", exec);
                        continue;
                    }
                    TypeElement alternativeTo = null;
                    try {
                        alternative.to();
                    }
                    catch (MirroredTypeException mte) {
                        alternativeTo = this.asTypeElement(mte.getTypeMirror());
                    }
                    String namedAttribute = alternative.named();
                    Optional<String> injectionName = this.getInjectionName(alternativeTo.getAnnotation(Named.class));
                    String componentName = !namedAttribute.isEmpty() ? namedAttribute : (injectionName.isPresent() ? (String)injectionName.get() : alternativeTo.getSimpleName().toString());
                    this.processConditionalProviderMethod(mod, module, alternativeTo.getQualifiedName().toString(), componentName, alternative.priority(), whenToUse, "Alternative", exec);
                }
                this.generateMachineFile(module);
            }
            catch (IOException e) {
                this.fatalError("error when processing " + element, e, element);
            }
        }
    }

    private void processProviderMethod(Module mod, ModuleClass module, Provides provides, ExecutableElement exec) {
        ProviderMethod m = new ProviderMethod(exec.getReturnType().toString(), exec.getSimpleName().toString(), provides.priority() == 0 ? mod.priority() : provides.priority(), this.getInjectionName(exec.getAnnotation(Named.class)), exec);
        this.buildInjectableParams(exec, m.parameters);
        this.buildCheckedExceptions(exec, m.exceptions);
        module.providerMethods.add(m);
    }

    private void processConditionalProviderMethod(Module mod, ModuleClass module, String componentType, String componentName, int priority, When when, String factoryMachineNameSuffix, ExecutableElement exec) {
        ConditionalProviderMethod m = new ConditionalProviderMethod(componentType, componentName, exec.getSimpleName().toString(), priority == 0 ? mod.priority() : priority, when.name(), when.value(), factoryMachineNameSuffix, exec);
        this.buildInjectableParams(exec, m.parameters);
        this.buildCheckedExceptions(exec, m.exceptions);
        module.conditionalProviderMethods.add(m);
    }

    private void processMachines(RoundEnvironment roundEnv) throws IOException {
        for (Element element : roundEnv.getElementsAnnotatedWith(Machine.class)) {
            try {
                if (!(element instanceof TypeElement)) {
                    this.error("annotating element " + element + " of type " + element.getKind().name() + " with @Machine is not supported", element);
                    continue;
                }
                TypeElement typeElem = (TypeElement)element;
                this.machinesDeclaration.declareService(typeElem.getQualifiedName().toString());
            }
            catch (Exception e) {
                this.fatalError("error when processing " + element, e, element);
            }
        }
    }

    private void processComponents(RoundEnvironment roundEnv) throws IOException {
        for (Element element : roundEnv.getElementsAnnotatedWith(Component.class)) {
            try {
                if (!(element instanceof TypeElement)) {
                    this.error("annotating element " + element + " of type " + element.getKind().name() + " with @Component is not supported", element);
                    continue;
                }
                TypeElement component = (TypeElement)element;
                ExecutableElement exec = this.findInjectableConstructor(component);
                Component componentAnnotation = component.getAnnotation(Component.class);
                TypeElement asClass = null;
                try {
                    componentAnnotation.asClass();
                }
                catch (MirroredTypeException mte) {
                    asClass = this.asTypeElement(mte.getTypeMirror());
                }
                if (asClass == null) {
                    asClass = component;
                }
                ComponentClass componentClass = new ComponentClass(component.getQualifiedName().toString(), this.getPackage(component).getQualifiedName().toString(), component.getSimpleName().toString(), asClass.getQualifiedName().toString(), this.getInjectionName(component.getAnnotation(Named.class)), componentAnnotation.priority(), component);
                this.buildInjectableParams(exec, componentClass.parameters);
                When when = component.getAnnotation(When.class);
                if (when == null) {
                    this.generateMachineFile(componentClass);
                    continue;
                }
                this.generateMachineFile(componentClass, when);
            }
            catch (Exception e) {
                this.fatalError("error when processing " + element, e, element);
            }
        }
    }

    private void processAlternatives(RoundEnvironment roundEnv) throws IOException {
        for (Element element : roundEnv.getElementsAnnotatedWith(Alternative.class)) {
            try {
                String namedAttribute;
                if (element instanceof ExecutableElement && element.getKind() == ElementKind.METHOD) continue;
                if (!(element instanceof TypeElement)) {
                    this.error("annotating element " + element + " of type " + element.getKind().name() + " with @Alternative is not supported", element);
                    continue;
                }
                TypeElement component = (TypeElement)element;
                ExecutableElement exec = this.findInjectableConstructor(component);
                Alternative alternative = component.getAnnotation(Alternative.class);
                TypeElement alternativeTo = null;
                if (alternative != null) {
                    try {
                        alternative.to();
                    }
                    catch (MirroredTypeException mte) {
                        alternativeTo = this.asTypeElement(mte.getTypeMirror());
                    }
                }
                Optional<String> injectionName = !(namedAttribute = alternative.named()).isEmpty() ? Optional.of((Object)namedAttribute) : this.getInjectionName(alternativeTo.getAnnotation(Named.class));
                ComponentClass componentClass = new ComponentClass(component.getQualifiedName().toString(), this.getPackage(component).getQualifiedName().toString(), component.getSimpleName().toString(), this.getInjectionName(component.getAnnotation(Named.class)), alternative.priority(), component);
                ComponentClass alternativeToComponentClass = new ComponentClass(alternativeTo.getQualifiedName().toString(), this.getPackage(alternativeTo).getQualifiedName().toString(), alternativeTo.getSimpleName().toString(), injectionName, alternative.priority(), alternativeTo);
                When when = component.getAnnotation(When.class);
                if (when == null) {
                    this.error("an Alternative MUST be annotated with @When to tell when it must be activated", element);
                    continue;
                }
                Named named = component.getAnnotation(Named.class);
                if (named != null) {
                    this.warn("to specify a 'name' for an Alternative use 'named' attribute, Named annotation will be ignored", element);
                }
                this.buildInjectableParams(exec, componentClass.parameters);
                this.generateMachineFile(componentClass, alternativeToComponentClass, when);
            }
            catch (Exception e) {
                this.fatalError("error when processing " + element, e, element);
            }
        }
    }

    private ExecutableElement findInjectableConstructor(TypeElement component) {
        ExecutableElement exec = null;
        for (Element element : component.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement) || element.getKind() != ElementKind.CONSTRUCTOR || exec != null && element.getAnnotation(Inject.class) == null || (exec = (ExecutableElement)element).getAnnotation(Inject.class) == null) continue;
            return exec;
        }
        return exec;
    }

    private void buildCheckedExceptions(ExecutableElement executableElement, List<String> exceptions) {
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            String exception = ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString();
            exceptions.add(exception);
        }
    }

    private void buildInjectableParams(ExecutableElement executableElement, List<InjectableParameter> parameters) {
        for (VariableElement variableElement : executableElement.getParameters()) {
            parameters.add(new InjectableParameter(variableElement.asType(), variableElement.getSimpleName().toString(), this.getInjectionName(variableElement.getAnnotation(Named.class))));
        }
    }

    private Optional<String> getInjectionName(Named named) {
        return named != null ? Optional.of((Object)named.value()) : Optional.absent();
    }

    private void generateMachineFile(ModuleClass moduleClass) throws IOException {
        ArrayList engines = Lists.newArrayList();
        ArrayList conditionalsEngines = Lists.newArrayList();
        for (ProviderMethod providerMethod : moduleClass.providerMethods) {
            engines.add(ImmutableMap.builder().put((Object)"type", (Object)providerMethod.type).put((Object)"name", (Object)providerMethod.name).put((Object)"enginePriority", (Object)providerMethod.priority).put((Object)"injectionName", providerMethod.injectionName.isPresent() ? providerMethod.injectionName.get() : providerMethod.name).put((Object)"queriesDeclarations", (Object)Joiner.on((String)"\n").join(this.buildQueriesDeclarationsCode(providerMethod.parameters))).put((Object)"queries", (Object)Joiner.on((String)",\n").join(this.buildQueriesNames(providerMethod.parameters))).put((Object)"parameters", (Object)Joiner.on((String)",\n").join(this.buildParamFromSatisfiedBomCode(providerMethod.parameters))).put((Object)"exceptions", providerMethod.exceptions.isEmpty() ? Boolean.valueOf(false) : Joiner.on((String)"|").join(providerMethod.exceptions)).build());
        }
        for (ConditionalProviderMethod conditionalProviderMethod : moduleClass.conditionalProviderMethods) {
            conditionalsEngines.add(ImmutableMap.builder().put((Object)"componentType", (Object)conditionalProviderMethod.componentType).put((Object)"componentName", (Object)conditionalProviderMethod.componentName).put((Object)"conditionalFactoryMachineName", (Object)(conditionalProviderMethod.methodName + conditionalProviderMethod.componentName + conditionalProviderMethod.factoryMachineNameSuffix)).put((Object)"whenName", (Object)conditionalProviderMethod.whenName).put((Object)"whenValue", (Object)conditionalProviderMethod.whenValue).put((Object)"priority", (Object)conditionalProviderMethod.priority).put((Object)"queriesDeclarations", (Object)Joiner.on((String)"\n").join(this.buildQueriesDeclarationsCode(conditionalProviderMethod.parameters))).put((Object)"methodName", (Object)conditionalProviderMethod.methodName).put((Object)"queries", (Object)Joiner.on((String)",\n").join(this.buildQueriesNames(conditionalProviderMethod.parameters))).put((Object)"parameters", (Object)Joiner.on((String)",\n").join(this.buildParamFromSatisfiedBomCode(conditionalProviderMethod.parameters))).put((Object)"exceptions", conditionalProviderMethod.exceptions.isEmpty() ? Boolean.valueOf(false) : Joiner.on((String)"|").join(conditionalProviderMethod.exceptions)).build());
        }
        ImmutableMap ctx = ImmutableMap.builder().put((Object)"package", (Object)moduleClass.pack).put((Object)"machine", (Object)(moduleClass.name + "FactoryMachine")).put((Object)"moduleFqcn", (Object)moduleClass.fqcn).put((Object)"moduleType", (Object)moduleClass.name).put((Object)"priority", (Object)moduleClass.priority).put((Object)"engines", (Object)engines).put((Object)"conditionalsEngines", (Object)conditionalsEngines).build();
        this.generateJavaClass(moduleClass.fqcn + "FactoryMachine", this.moduleMachineTpl, ctx, Collections.singleton(moduleClass.originatingElement));
    }

    private void generateMachineFile(ComponentClass componentClass, ComponentClass alternativeTo, When when) throws IOException {
        ImmutableMap ctx = ImmutableMap.builder().put((Object)"package", (Object)componentClass.pack).put((Object)"machine", (Object)(componentClass.name + "FactoryMachine")).put((Object)"imports", (Object)ImmutableList.of((Object)componentClass.fqcn, (Object)alternativeTo.fqcn)).put((Object)"componentType", (Object)componentClass.name).put((Object)"componentInjectionType", (Object)alternativeTo.name).put((Object)"priority", (Object)String.valueOf(componentClass.priority)).put((Object)"whenName", (Object)when.name()).put((Object)"whenValue", (Object)when.value()).put((Object)"componentInjectionName", alternativeTo.injectionName.or((Object)alternativeTo.name)).put((Object)"conditionalFactoryMachineName", (Object)(componentClass.name + alternativeTo.name + "Alternative")).put((Object)"queriesDeclarations", (Object)Joiner.on((String)"\n").join(this.buildQueriesDeclarationsCode(componentClass.parameters))).put((Object)"queries", (Object)Joiner.on((String)",\n").join(this.buildQueriesNames(componentClass.parameters))).put((Object)"parameters", (Object)Joiner.on((String)",\n").join(this.buildParamFromSatisfiedBomCode(componentClass.parameters))).build();
        this.generateJavaClass(componentClass.pack + "." + componentClass.name + "FactoryMachine", this.conditionalMachineTpl, ctx, Collections.singleton(componentClass.originatingElement));
    }

    private void generateMachineFile(ComponentClass componentClass, When when) throws IOException {
        ImmutableMap ctx = ImmutableMap.builder().put((Object)"package", (Object)componentClass.pack).put((Object)"machine", (Object)(componentClass.name + "FactoryMachine")).put((Object)"imports", (Object)ImmutableList.of((Object)componentClass.fqcn)).put((Object)"componentType", (Object)componentClass.name).put((Object)"componentInjectionType", (Object)componentClass.producedName).put((Object)"priority", (Object)String.valueOf(componentClass.priority)).put((Object)"whenName", (Object)when.name()).put((Object)"whenValue", (Object)when.value()).put((Object)"componentInjectionName", componentClass.injectionName.isPresent() ? componentClass.injectionName.get() : componentClass.name).put((Object)"conditionalFactoryMachineName", (Object)(componentClass.name + componentClass.name + "Conditional")).put((Object)"queriesDeclarations", (Object)Joiner.on((String)"\n").join(this.buildQueriesDeclarationsCode(componentClass.parameters))).put((Object)"queries", (Object)Joiner.on((String)",\n").join(this.buildQueriesNames(componentClass.parameters))).put((Object)"parameters", (Object)Joiner.on((String)",\n").join(this.buildParamFromSatisfiedBomCode(componentClass.parameters))).build();
        this.generateJavaClass(componentClass.pack + "." + componentClass.name + "FactoryMachine", this.conditionalMachineTpl, ctx, Collections.singleton(componentClass.originatingElement));
    }

    private void generateMachineFile(ComponentClass componentClass) throws IOException {
        ImmutableMap ctx = ImmutableMap.builder().put((Object)"package", (Object)componentClass.pack).put((Object)"machine", (Object)(componentClass.name + "FactoryMachine")).put((Object)"componentFqcn", (Object)componentClass.fqcn).put((Object)"componentType", (Object)componentClass.name).put((Object)"componentProducedType", (Object)componentClass.producedName).put((Object)"priority", (Object)String.valueOf(componentClass.priority)).put((Object)"componentInjectionName", (Object)(componentClass.injectionName.isPresent() ? (String)componentClass.injectionName.get() : componentClass.name)).put((Object)"queriesDeclarations", (Object)Joiner.on((String)"\n").join(this.buildQueriesDeclarationsCode(componentClass.parameters))).put((Object)"queries", (Object)Joiner.on((String)",\n").join(this.buildQueriesNames(componentClass.parameters))).put((Object)"parameters", (Object)Joiner.on((String)",\n").join(this.buildParamFromSatisfiedBomCode(componentClass.parameters))).build();
        this.generateJavaClass(componentClass.pack + "." + componentClass.name + "FactoryMachine", this.componentMachineTpl, ctx, Collections.singleton(componentClass.originatingElement));
    }

    private List<String> buildQueriesDeclarationsCode(List<InjectableParameter> parameters) {
        ArrayList parametersCode = Lists.newArrayList();
        for (InjectableParameter parameter : parameters) {
            parametersCode.add(parameter.getQueryDeclarationCode());
        }
        return parametersCode;
    }

    private List<String> buildQueriesNames(List<InjectableParameter> parameters) {
        ArrayList parametersCode = Lists.newArrayList();
        for (InjectableParameter parameter : parameters) {
            parametersCode.add(parameter.name);
        }
        return parametersCode;
    }

    private List<String> buildParamFromSatisfiedBomCode(List<InjectableParameter> parameters) {
        ArrayList parametersCode = Lists.newArrayList();
        for (InjectableParameter parameter : parameters) {
            parametersCode.add(parameter.getFromSatisfiedBomCode());
        }
        return parametersCode;
    }

    private class ServicesDeclaration
    extends RestxAbstractProcessor.ResourceDeclaration {
        private final Set<String> declaredServices;

        private ServicesDeclaration(String targetFile) {
            super((RestxAbstractProcessor)FactoryAnnotationProcessor.this, "META-INF/services/" + targetFile);
            this.declaredServices = Sets.newHashSet();
        }

        protected boolean requireGeneration() {
            return this.declaredServices.size() > 0;
        }

        protected void clearContent() {
            this.declaredServices.clear();
        }

        protected void writeContent(Writer writer) throws IOException {
            for (String declaredService : Ordering.natural().sortedCopy(this.declaredServices)) {
                writer.write(declaredService + "\n");
            }
        }

        protected void readContent(Reader reader) throws IOException {
            this.declaredServices.addAll(CharStreams.readLines((Readable)reader));
        }

        void declareService(String service) {
            this.declaredServices.add(service);
        }
    }

    private static class ModuleClass {
        final String fqcn;
        final List<ProviderMethod> providerMethods = Lists.newArrayList();
        final List<ConditionalProviderMethod> conditionalProviderMethods = Lists.newArrayList();
        final Element originatingElement;
        final String pack;
        final String name;
        final int priority;

        ModuleClass(String fqcn, Element originatingElement, int priority) {
            this.fqcn = fqcn;
            this.pack = fqcn.substring(0, fqcn.lastIndexOf(46));
            this.name = fqcn.substring(fqcn.lastIndexOf(46) + 1);
            this.originatingElement = originatingElement;
            this.priority = priority;
        }
    }

    private static class ProviderMethod {
        final Element originatingElement;
        final String type;
        final String name;
        final int priority;
        final Optional<String> injectionName;
        final List<InjectableParameter> parameters = Lists.newArrayList();
        final List<String> exceptions = Lists.newArrayList();

        ProviderMethod(String type, String name, int priority, Optional<String> injectionName, Element originatingElement) {
            this.type = type;
            this.name = name;
            this.priority = priority;
            this.injectionName = injectionName;
            this.originatingElement = originatingElement;
        }
    }

    private static class ConditionalProviderMethod {
        final Element originatingElement;
        final String componentType;
        final String componentName;
        final String methodName;
        final int priority;
        final String whenName;
        final String whenValue;
        final String factoryMachineNameSuffix;
        final List<InjectableParameter> parameters = Lists.newArrayList();
        final List<String> exceptions = Lists.newArrayList();

        ConditionalProviderMethod(String componentType, String componentName, String methodName, int priority, String whenName, String whenValue, String factoryMachineNameSuffix, Element originatingElement) {
            this.componentType = componentType;
            this.componentName = componentName;
            this.methodName = methodName;
            this.priority = priority;
            this.whenName = whenName;
            this.whenValue = whenValue;
            this.originatingElement = originatingElement;
            this.factoryMachineNameSuffix = factoryMachineNameSuffix;
        }
    }

    private static class ComponentClass {
        final String fqcn;
        final List<InjectableParameter> parameters = Lists.newArrayList();
        final Element originatingElement;
        final String pack;
        final String name;
        final String producedName;
        final int priority;
        final Optional<String> injectionName;

        ComponentClass(String fqcn, String pack, String name, Optional<String> injectionName, int priority, Element originatingElement) {
            this(fqcn, pack, name, name, injectionName, priority, originatingElement);
        }

        ComponentClass(String fqcn, String pack, String name, String producedName, Optional<String> injectionName, int priority, Element originatingElement) {
            this.fqcn = fqcn;
            this.injectionName = injectionName;
            this.priority = priority;
            this.pack = pack;
            this.name = name;
            this.producedName = producedName;
            this.originatingElement = originatingElement;
        }
    }

    private static class InjectableParameter {
        private static final Class[] iterableClasses = new Class[]{Iterable.class, Collection.class, List.class, Set.class, ImmutableList.class, ImmutableSet.class};
        final TypeMirror baseType;
        final String name;
        final Optional<String> injectionName;

        private InjectableParameter(TypeMirror baseType, String name, Optional<String> injectionName) {
            this.baseType = baseType;
            this.name = name;
            this.injectionName = injectionName;
        }

        public String getQueryDeclarationCode() {
            String optionalOrNotQueryQualifier;
            TypeMirror targetType = this.targetType(this.baseType);
            String string = optionalOrNotQueryQualifier = this.isGuavaOptionalType(this.baseType) || this.isJava8OptionalType(this.baseType) || this.isMultiType(this.baseType) ? "optional()" : "mandatory()";
            if (this.injectionName.isPresent()) {
                return String.format("private final Factory.Query<%s> %s = Factory.Query.byName(Name.of(%s, \"%s\")).%s;", targetType, this.name, targetType + ".class", this.injectionName.get(), optionalOrNotQueryQualifier);
            }
            return String.format("private final Factory.Query<%s> %s = Factory.Query.byClass(%s).%s;", targetType, this.name, targetType + ".class", optionalOrNotQueryQualifier);
        }

        public String getFromSatisfiedBomCode() {
            if (this.isGuavaOptionalType(this.baseType)) {
                return String.format("satisfiedBOM.getOneAsComponent(%s)", this.name);
            }
            if (this.isJava8OptionalType(this.baseType)) {
                return String.format("java.util.Optional.ofNullable(satisfiedBOM.getOneAsComponent(%s).orNull())", this.name);
            }
            if (this.isNamedComponentType(this.baseType)) {
                return String.format("satisfiedBOM.getOne(%s).get()", this.name);
            }
            if (this.isMultiType(this.baseType)) {
                TypeMirror pType = (TypeMirror)this.parameterType(this.baseType).get();
                String code = this.isNamedComponentType(pType) ? String.format("satisfiedBOM.get(%s)", this.name) : String.format("satisfiedBOM.getAsComponents(%s)", this.name);
                if (this.baseType.toString().startsWith(Collection.class.getCanonicalName()) || this.baseType.toString().startsWith(List.class.getCanonicalName())) {
                    code = String.format("com.google.common.collect.Lists.newArrayList(%s)", code);
                } else if (this.baseType.toString().startsWith(Set.class.getCanonicalName())) {
                    code = String.format("com.google.common.collect.Sets.newLinkedHashSet(%s)", code);
                } else if (this.baseType.toString().startsWith(ImmutableList.class.getCanonicalName())) {
                    code = String.format("com.google.common.collect.ImmutableList.copyOf(%s)", code);
                } else if (this.baseType.toString().startsWith(ImmutableSet.class.getCanonicalName())) {
                    code = String.format("com.google.common.collect.ImmutableSet.copyOf(%s)", code);
                }
                return code;
            }
            return String.format("satisfiedBOM.getOne(%s).get().getComponent()", this.name);
        }

        private TypeMirror targetType(TypeMirror type) {
            if (this.isGuavaOptionalType(type) || this.isJava8OptionalType(type) || this.isMultiType(type) || this.isNamedComponentType(type)) {
                Optional<TypeMirror> pType = this.parameterType(type);
                if (!pType.isPresent()) {
                    throw new RuntimeException("Optional | Collection | NamedComponent type for parameter " + this.name + " needs parameterized type (generics) to be processed correctly");
                }
                return this.targetType((TypeMirror)pType.get());
            }
            return type;
        }

        private Optional<TypeMirror> parameterType(TypeMirror type) {
            if (type instanceof DeclaredType) {
                DeclaredType declaredBaseType = (DeclaredType)type;
                if (declaredBaseType.getTypeArguments().isEmpty()) {
                    return Optional.absent();
                }
                return Optional.of((Object)declaredBaseType.getTypeArguments().get(0));
            }
            return Optional.absent();
        }

        private boolean isGuavaOptionalType(TypeMirror type) {
            return type.toString().startsWith(Optional.class.getCanonicalName());
        }

        private boolean isJava8OptionalType(TypeMirror type) {
            return type.toString().startsWith("java.util.Optional");
        }

        private boolean isNamedComponentType(TypeMirror type) {
            return type.toString().startsWith(NamedComponent.class.getCanonicalName());
        }

        private boolean isMultiType(TypeMirror type) {
            for (Class it : iterableClasses) {
                if (!type.toString().startsWith(it.getCanonicalName())) continue;
                return true;
            }
            return false;
        }
    }
}

