/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.collect.ImmutableMap;
import restx.factory.BillOfMaterials;
import restx.factory.ComponentBox;
import restx.factory.Factory;
import restx.factory.FactoryMachine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.NoopFactoryMachine;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;

public class AlternativesFactoryMachine<T>
extends SingleNameFactoryMachine<FactoryMachine> {
    public AlternativesFactoryMachine(int priority, final Name<T> name, final ImmutableMap<T, ? extends FactoryMachine> alternatives, ComponentBox.BoxFactory boxFactory) {
        super(priority, new StdMachineEngine<FactoryMachine>(Name.of(FactoryMachine.class, name.getName() + "Alternatives"), priority, boxFactory){
            private Factory.Query<T> query;
            {
                super(name3, priority, boxFactory);
                this.query = Factory.Query.byName(name);
            }

            @Override
            protected FactoryMachine doNewComponent(SatisfiedBOM satisfiedBOM) {
                FactoryMachine factoryMachine = (FactoryMachine)alternatives.get(((NamedComponent)satisfiedBOM.getOne(this.query).get()).getComponent());
                if (factoryMachine != null) {
                    return factoryMachine;
                }
                return NoopFactoryMachine.INSTANCE;
            }

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return BillOfMaterials.of(this.query);
            }
        });
    }
}

