/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import restx.factory.ComponentBox;
import restx.factory.ComponentCustomizer;
import restx.factory.Name;
import restx.factory.NamedComponent;

public class BoundlessComponentBox<T>
implements ComponentBox<T> {
    public static final ComponentBox.BoxFactory FACTORY = new ComponentBox.BoxFactory(){

        @Override
        public <T> ComponentBox<T> of(NamedComponent<T> namedComponent) {
            return new BoundlessComponentBox<T>(namedComponent);
        }

        public String toString() {
            return "BoundlessComponentBox.FACTORY";
        }
    };
    private final NamedComponent<T> namedComponent;

    public BoundlessComponentBox(NamedComponent<T> namedComponent) {
        this.namedComponent = (NamedComponent)Preconditions.checkNotNull(namedComponent);
    }

    @Override
    public ComponentBox<T> customize(ComponentCustomizer<T> customizer) {
        NamedComponent<T> customized = customizer.customize(this.namedComponent);
        if (customized != this.namedComponent) {
            return new BoundlessComponentBox<T>(customized);
        }
        return this;
    }

    @Override
    public void close() {
        if (this.namedComponent.getComponent() instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.namedComponent.getComponent()).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized Optional<NamedComponent<T>> pick() {
        return Optional.of(this.namedComponent);
    }

    @Override
    public Name<T> getName() {
        return this.namedComponent.getName();
    }

    public String toString() {
        return "BoundlessComponentBox{namedComponent=" + this.namedComponent + "}";
    }
}

