/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import restx.factory.BillOfMaterials;
import restx.factory.ComponentBox;
import restx.factory.ComponentBoxWrapper;
import restx.factory.Factory;
import restx.factory.FactoryMachine;
import restx.factory.MachineEngine;
import restx.factory.MachineEngineWrapper;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;

public class FactoryMachineWrapper
implements FactoryMachine {
    private final FactoryMachine original;

    public static Builder from(FactoryMachine factoryMachine) {
        return new Builder().from(factoryMachine);
    }

    public FactoryMachineWrapper(FactoryMachine original) {
        this.original = original;
    }

    @Override
    public boolean canBuild(Name<?> name) {
        return this.original.canBuild(name);
    }

    @Override
    public int priority() {
        return this.original.priority();
    }

    @Override
    public <T> MachineEngine<T> getEngine(Name<T> name) {
        return this.original.getEngine(name);
    }

    @Override
    public <T> Set<Name<T>> nameBuildableComponents(Class<T> componentClass) {
        return this.original.nameBuildableComponents(componentClass);
    }

    public String toString() {
        return "FactoryMachineWrapper{original=" + this.original + "}";
    }

    public static class Builder {
        private FactoryMachine factoryMachine;
        private Integer priority;
        private Function transform;
        private List<Factory.Query<?>> deps = Lists.newArrayList();

        public Builder from(FactoryMachine factoryMachine) {
            this.factoryMachine = factoryMachine;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder withDependencies(Factory.Query<?> ... q) {
            this.deps.addAll(Lists.newArrayList((Object[])q));
            return this;
        }

        public Builder transformComponents(Function<Map.Entry<SatisfiedBOM, NamedComponent>, NamedComponent> transform) {
            this.transform = transform;
            return this;
        }

        public FactoryMachine build() {
            if (this.transform == null) {
                return new FactoryMachineWrapper(this.factoryMachine){

                    @Override
                    public int priority() {
                        return priority == null ? super.priority() : priority.intValue();
                    }
                };
            }
            return new FactoryMachineWrapper(this.factoryMachine){

                @Override
                public int priority() {
                    return priority == null ? super.priority() : priority.intValue();
                }

                @Override
                public <T> MachineEngine<T> getEngine(Name<T> name) {
                    return new MachineEngineWrapper<T>(super.getEngine(name)){

                        @Override
                        public BillOfMaterials getBillOfMaterial() {
                            return super.getBillOfMaterial().addQueries(deps);
                        }

                        @Override
                        public ComponentBox<T> newComponent(final SatisfiedBOM satisfiedBOM) {
                            return new ComponentBoxWrapper<T>(super.newComponent(satisfiedBOM)){

                                @Override
                                public Optional<NamedComponent<T>> pick() {
                                    Optional pick = super.pick();
                                    if (!pick.isPresent()) {
                                        return pick;
                                    }
                                    return Optional.of((Object)((NamedComponent)transform.apply((Object)Maps.immutableEntry((Object)satisfiedBOM, (Object)((NamedComponent)pick.get())))));
                                }
                            };
                        }
                    };
                }
            };
        }
    }
}

