/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import restx.factory.BillOfMaterials;
import restx.factory.Factory;
import restx.factory.NamedComponent;

public class SatisfiedBOM {
    private final BillOfMaterials bom;
    private final ImmutableMultimap<Factory.Query<?>, NamedComponent<?>> materials;

    public SatisfiedBOM(BillOfMaterials bom, ImmutableMultimap<Factory.Query<?>, NamedComponent<?>> materials) {
        this.bom = bom;
        this.materials = materials;
    }

    public BillOfMaterials getBom() {
        return this.bom;
    }

    public <T> Iterable<NamedComponent<T>> get(Factory.Query<T> key) {
        ImmutableCollection namedComponents = (ImmutableCollection)Preconditions.checkNotNull((Object)this.materials.get(key), (String)"key not found: %s. Check your bill of materials. Available keys: %s", key, (Object)this.materials.keySet());
        return namedComponents;
    }

    public <T> Iterable<T> getAsComponents(Factory.Query<T> key) {
        return Iterables.transform(this.get(key), NamedComponent.toComponent());
    }

    public <T> Optional<NamedComponent<T>> getOne(Factory.Query<T> key) {
        Iterator<NamedComponent<T>> components = this.get(key).iterator();
        if (!components.hasNext()) {
            return Optional.absent();
        }
        NamedComponent<T> component = components.next();
        if (components.hasNext()) {
            throw new IllegalStateException(String.format("more than one component is available for %s. Please select which one you want with a more specific query. Available components are: %s", key, this.materials.get(key)));
        }
        return Optional.of(component);
    }

    public <T> Optional<T> getOneAsComponent(Factory.Query<T> key) {
        Optional<NamedComponent<T>> namedComponent = this.getOne(key);
        if (namedComponent.isPresent()) {
            return Optional.of(((NamedComponent)namedComponent.get()).getComponent());
        }
        return Optional.absent();
    }

    public String toString() {
        return "SatisfiedBOM{bom=" + this.bom + ", materials=" + this.materials + "}";
    }

    public Iterable<NamedComponent<? extends Object>> getAllComponents() {
        return this.materials.values();
    }
}

