/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.Set;
import restx.factory.BillOfMaterials;
import restx.factory.ComponentBox;
import restx.factory.FactoryMachine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.Warehouse;

public class WarehouseProvidersMachine
implements FactoryMachine {
    private final ImmutableList<Warehouse> providers;

    public WarehouseProvidersMachine(ImmutableList<Warehouse> providers) {
        this.providers = providers;
    }

    @Override
    public boolean canBuild(Name<?> name) {
        for (Warehouse provider : this.providers) {
            for (Name<?> n : provider.listNames()) {
                if (!Predicates.equalTo(name).apply(n)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> MachineEngine<T> getEngine(final Name<T> name) {
        final Optional<NamedComponent<T>> component = this.findComponent(name);
        if (!component.isPresent()) {
            throw new IllegalArgumentException("can't build " + name);
        }
        final BillOfMaterials bom = this.findBomFor(name);
        return new MachineEngine<T>(){

            @Override
            public Name<T> getName() {
                return name;
            }

            @Override
            public int getPriority() {
                return ((NamedComponent)component.get()).getPriority();
            }

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return bom;
            }

            @Override
            public ComponentBox<T> newComponent(SatisfiedBOM satisfiedBOM) {
                throw new UnsupportedOperationException("WarehouseProvidersMachine Engine should never be used to actually build components, they should be picked up in the warehouse directly.");
            }

            public String toString() {
                return WarehouseProvidersMachine.this.toString() + "Engine";
            }
        };
    }

    private <T> BillOfMaterials findBomFor(Name<T> name) {
        for (Warehouse provider : this.providers) {
            Optional<Warehouse.StoredBox<T>> storedBox = provider.getStoredBox(name);
            if (!storedBox.isPresent()) continue;
            return ((Warehouse.StoredBox)storedBox.get()).getSatisfiedBOM().getBom();
        }
        throw new IllegalArgumentException("name not found " + name);
    }

    private <T> Optional<NamedComponent<T>> findComponent(Name<T> name) {
        for (Warehouse provider : this.providers) {
            Optional<NamedComponent<T>> componentOptional = provider.checkOut(name);
            if (!componentOptional.isPresent()) continue;
            return componentOptional;
        }
        return Optional.absent();
    }

    @Override
    public <T> Set<Name<T>> nameBuildableComponents(Class<T> componentClass) {
        LinkedHashSet<Name<T>> names = new LinkedHashSet<Name<T>>();
        for (Warehouse provider : this.providers) {
            for (Name<?> name : provider.listNames()) {
                if (!componentClass.isAssignableFrom(name.getClazz())) continue;
                names.add(name);
            }
        }
        return names;
    }

    @Override
    public int priority() {
        return -10000;
    }

    public String toString() {
        return "WarehouseProvidersMachine{providers=" + this.providers + "}";
    }
}

