/*
 * Decompiled with CFR 0.152.
 */
package restx.i18n.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Named;
import restx.annotations.GET;
import restx.annotations.POST;
import restx.annotations.RestxResource;
import restx.factory.Component;
import restx.i18n.Messages;
import restx.i18n.MutableMessages;
import restx.i18n.SupportedLocale;
import restx.security.RolesAllowed;

@RestxResource(group="restx-admin")
@Component
public class MessagesAdminResource {
    private final Messages messages;
    private final Collection<SupportedLocale> supportedLocales;

    public MessagesAdminResource(@Named(value="Messages") Messages messages, Collection<SupportedLocale> supportedLocales) {
        this.messages = messages;
        this.supportedLocales = supportedLocales;
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/i18n/keys")
    public Iterable<String> keys() {
        return this.messages.keys();
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/i18n/locales")
    public Iterable<String> locales() {
        ArrayList<String> locales = new ArrayList<String>();
        for (SupportedLocale supportedLocale : this.supportedLocales) {
            String tag = supportedLocale.getLocale().toLanguageTag();
            locales.add(Locale.ROOT.toLanguageTag().equals(tag) ? "/" : tag);
        }
        return locales;
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/i18n/messages/{locale}")
    public Map<String, String> messages(String locale) {
        Locale l = this.toLocale(locale);
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (String key : this.messages.keys()) {
            m.put(key, this.messages.getMessageTemplate(key, l));
        }
        return m;
    }

    @RolesAllowed(value={"restx-admin"})
    @POST(value="/@/i18n/messages/{locale}")
    public void setMessage(String locale, Map<String, String> entries) {
        if (!(this.messages instanceof MutableMessages)) {
            throw new IllegalStateException("can't update messages: not a MutableMessages instance. Are you in PROD mode?");
        }
        try {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                ((MutableMessages)this.messages).setMessageTemplate(entry.getKey(), entry.getValue(), this.toLocale(locale));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Locale toLocale(String locale) {
        return "/".equals(locale) ? Locale.ROOT : Locale.forLanguageTag(locale);
    }
}

