/*
 * Decompiled with CFR 0.152.
 */
package restx.i18n.admin;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.annotations.POST;
import restx.common.TypeReference;
import restx.common.Types;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.Empty;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.i18n.admin.MessagesAdminResource;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;
import restx.validation.Validations;

@Component(priority=0)
public class MessagesAdminResourceRouter
extends RestxRouter {
    public MessagesAdminResourceRouter(final MessagesAdminResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, final Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "MessagesAdminResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, Iterable<String>>("restx-admin#MessagesAdminResource#keys", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{String.class}), Optional.absent()), Endpoint.of((String)"GET", (String)"/@/i18n/keys"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Iterable<String>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of(resource.keys());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "LIST[string]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{String.class});
                operation.sourceLocation = "restx.i18n.admin.MessagesAdminResource#keys()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/i18n/keys";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, Iterable<String>>("restx-admin#MessagesAdminResource#locales", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{String.class}), Optional.absent()), Endpoint.of((String)"GET", (String)"/@/i18n/locales"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Iterable<String>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of(resource.locales());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "LIST[string]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{String.class});
                operation.sourceLocation = "restx.i18n.admin.MessagesAdminResource#locales()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/i18n/locales";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, Map<String, String>>("restx-admin#MessagesAdminResource#messages", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, String.class}), Optional.absent()), Endpoint.of((String)"GET", (String)"/@/i18n/messages/{locale}"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"locale")}){

            protected Optional<Map<String, String>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of(resource.messages((String)Validations.checkValid((Optional)validator, (Object)((String)Preconditions.checkNotNull((Object)((String)this.mapQueryObjectFromRequest(String.class, "locale", request, match, EndpointParameterKind.PATH)), (Object)"PATH param <locale> is required")), (Class[])new Class[0])));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription locale = new OperationParameterDescription();
                locale.name = "locale";
                locale.paramType = OperationParameterDescription.ParamType.path;
                locale.dataType = "string";
                locale.schemaKey = "";
                locale.required = true;
                operation.parameters.add(locale);
                operation.responseClass = "MAP[string, string]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, String.class});
                operation.sourceLocation = "restx.i18n.admin.MessagesAdminResource#messages(java.lang.String)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/i18n/messages/{locale}";
                    }
                }).build();
            }
        }, new StdEntityRoute<Map<String, String>, Empty>("restx-admin#MessagesAdminResource#setMessage", readerRegistry.build((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, String.class}), Optional.absent()), writerRegistry.build(Void.TYPE, Optional.absent()), Endpoint.of((String)"POST", (String)"/@/i18n/messages/{locale}"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"locale")}){

            protected Optional<Empty> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Map<String, String> body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    resource.setMessage((String)Validations.checkValid((Optional)validator, (Object)((String)Preconditions.checkNotNull((Object)((String)this.mapQueryObjectFromRequest(String.class, "locale", request, match, EndpointParameterKind.PATH)), (Object)"PATH param <locale> is required")), (Class[])new Class[0]), (Map)Validations.checkValid((Optional)validator, (Object)((Map)Preconditions.checkNotNull(body, (Object)"body param <entries> is required")), (Class[])new Class[0]));
                    return Optional.of((Object)Empty.EMPTY);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription locale = new OperationParameterDescription();
                locale.name = "locale";
                locale.paramType = OperationParameterDescription.ParamType.path;
                locale.dataType = "string";
                locale.schemaKey = "";
                locale.required = true;
                operation.parameters.add(locale);
                OperationParameterDescription entries = new OperationParameterDescription();
                entries.name = "entries";
                entries.paramType = OperationParameterDescription.ParamType.body;
                entries.dataType = "MAP[string, string]";
                entries.schemaKey = "";
                entries.required = true;
                operation.parameters.add(entries);
                operation.responseClass = "void";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, String.class});
                operation.outEntitySchemaKey = "";
                operation.outEntityType = Void.TYPE;
                operation.sourceLocation = "restx.i18n.admin.MessagesAdminResource#setMessage(java.lang.String,java.util.Map<java.lang.String,java.lang.String>)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new POST(){

                    public Class<POST> annotationType() {
                        return POST.class;
                    }

                    public String value() {
                        return "/@/i18n/messages/{locale}";
                    }
                }).build();
            }
        }});
    }
}

