/*
 * Decompiled with CFR 0.152.
 */
package restx.i18n;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Ordering;
import com.google.common.io.Resources;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import restx.common.MoreResources;
import restx.i18n.AbstractMessages;
import restx.i18n.MessageParams;
import restx.i18n.Messages;

public class DefaultMessages
extends AbstractMessages
implements Messages {
    private final String baseName;
    private final Charset charset;
    private final LoadingCache<Locale, Iterable<String>> cachedKeysByLocale = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Locale, Iterable<String>>(){

        public Iterable<String> load(Locale locale) throws Exception {
            Optional<ResourceBundle> bundle = DefaultMessages.this.getBundle(locale);
            return bundle.isPresent() ? Ordering.natural().sortedCopy(((ResourceBundle)bundle.get()).keySet()) : Collections.emptySet();
        }
    });

    public DefaultMessages(String baseName) {
        this(baseName, StandardCharsets.UTF_8);
    }

    public DefaultMessages(String baseName, Charset charset) {
        this.baseName = baseName;
        this.charset = charset;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getMessage(String key, MessageParams params, Locale locale) {
        return this.getTemplate(key, locale).execute(params.toMap());
    }

    @Override
    public Iterable<String> keys(Locale locale) {
        return (Iterable)this.cachedKeysByLocale.getUnchecked((Object)locale);
    }

    protected void invalidateCachedKeysFor(Locale locale) {
        this.cachedKeysByLocale.invalidate((Object)locale);
    }

    @Override
    public Iterable<String> keys() {
        return this.keys(Locale.ROOT);
    }

    @Override
    public Iterable<Map.Entry<String, String>> entries(Locale locale) {
        Optional<ResourceBundle> rootBundle = this.getBundle(Locale.ROOT);
        Optional<ResourceBundle> bundle = this.getBundle(locale);
        if (rootBundle.isPresent()) {
            Set<String> keys = ((ResourceBundle)rootBundle.get()).keySet();
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(keys.size());
            for (String key : Ordering.natural().sortedCopy(keys)) {
                entries.add(new AbstractMap.SimpleEntry<String, String>(key, this.getTemplateString(key, locale, bundle)));
            }
            return entries;
        }
        return Collections.emptySet();
    }

    @Override
    public String getMessageTemplate(String key, Locale locale) {
        return this.getTemplateString(key, locale);
    }

    protected Template getTemplate(String key, Locale locale) {
        return Mustache.compiler().escapeHTML(false).compile(this.getTemplateString(key, locale));
    }

    protected String getTemplateString(String key, Locale locale) {
        return this.getTemplateString(key, locale, this.getBundle(locale));
    }

    private String getTemplateString(String key, Locale locale, Optional<ResourceBundle> bundle) {
        if (!bundle.isPresent()) {
            return key + "-[" + locale + "]";
        }
        try {
            return ((ResourceBundle)bundle.get()).getString(key);
        }
        catch (MissingResourceException e) {
            return key + "-[" + locale + "]";
        }
    }

    protected Optional<ResourceBundle> getBundle(Locale locale) {
        ResourceBundle.Control control = new ResourceBundle.Control(){

            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                PropertyResourceBundle propertyResourceBundle;
                block8: {
                    String bundleName = this.toBundleName(baseName, locale);
                    String resourceName = this.toResourceName(bundleName, "properties");
                    URL resource = DefaultMessages.this.getResource(resourceName);
                    Reader input = Resources.asCharSource((URL)resource, (Charset)DefaultMessages.this.charset).openStream();
                    try {
                        propertyResourceBundle = DefaultMessages.this.newResourceBundle(resource, input);
                        if (input == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IllegalArgumentException e) {
                            return null;
                        }
                    }
                    input.close();
                }
                return propertyResourceBundle;
            }

            @Override
            public List<String> getFormats(String baseName) {
                return ResourceBundle.Control.FORMAT_PROPERTIES;
            }

            @Override
            public Locale getFallbackLocale(String baseName, Locale locale) {
                if (baseName == null || locale == null) {
                    throw new NullPointerException();
                }
                return null;
            }

            @Override
            public long getTimeToLive(String baseName, Locale locale) {
                return DefaultMessages.this.getTimeToLive();
            }
        };
        try {
            return Optional.of((Object)ResourceBundle.getBundle(this.baseName, locale, control));
        }
        catch (MissingResourceException e) {
            return Optional.absent();
        }
    }

    protected PropertyResourceBundle newResourceBundle(URL resource, Reader input) throws IOException {
        return new PropertyResourceBundle(input);
    }

    protected long getTimeToLive() {
        return -2L;
    }

    protected URL getResource(String resourceName) {
        return MoreResources.getResource((String)resourceName, (boolean)false);
    }

    public String toString() {
        return "DefaultMessages{baseName='" + this.baseName + "', charset=" + this.charset + "}";
    }
}

