/*
 * Decompiled with CFR 0.152.
 */
package restx.i18n;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import restx.common.MoreResources;
import restx.i18n.DefaultMessages;
import restx.i18n.MutableMessages;

public class DefaultMutableMessages
extends DefaultMessages
implements MutableMessages {
    public DefaultMutableMessages(String baseName) {
        super(baseName);
    }

    public DefaultMutableMessages(String baseName, Charset charset) {
        super(baseName, charset);
    }

    @Override
    public MutableMessages setMessageTemplate(String key, String messageTemplate, Locale locale) throws IOException {
        Optional<ResourceBundle> b = this.getBundle(locale);
        if (!b.isPresent()) {
            throw new IllegalStateException("bundle not found: " + this.getBaseName() + " - " + locale);
        }
        MutablePropertyResourceBundle bundle = (MutablePropertyResourceBundle)b.get();
        bundle.setMessageTemplate(key, messageTemplate);
        this.invalidateCachedKeysFor(locale);
        return this;
    }

    @Override
    protected PropertyResourceBundle newResourceBundle(URL resource, Reader input) throws IOException {
        return new MutablePropertyResourceBundle(input, resource, this.getCharset());
    }

    @Override
    protected long getTimeToLive() {
        return -1L;
    }

    @Override
    protected URL getResource(String resourceName) {
        return MoreResources.getResource((String)resourceName, (boolean)true);
    }

    private static void updateProperties(File file, Charset charset, ImmutableMap<String, String> properties) throws IOException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>((Map<String, String>)properties);
        String s = Files.toString((File)file, (Charset)charset);
        StringBuilder out = new StringBuilder();
        boolean updated = false;
        String[] lines = s.split("(?m)$");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.indexOf(61) != -1) {
                String p = line.substring(0, line.indexOf(61));
                if (props.containsKey(p.trim())) {
                    updated = true;
                    out.append(p).append("=").append((String)properties.get((Object)p.trim()));
                    props.remove(p.trim());
                    continue;
                }
                out.append(line);
                continue;
            }
            out.append(line);
        }
        if (!props.isEmpty()) {
            updated = true;
            for (Map.Entry entry : props.entrySet()) {
                out.append("\n").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            out.append("\n");
        }
        if (updated) {
            Files.write((CharSequence)out.toString(), (File)file, (Charset)charset);
        }
    }

    private static class MutablePropertyResourceBundle
    extends PropertyResourceBundle {
        private final URL resource;
        private final Charset charset;

        public MutablePropertyResourceBundle(Reader input, URL resource, Charset charset) throws IOException {
            super(input);
            this.resource = resource;
            this.charset = charset;
        }

        public void setMessageTemplate(String key, String value) throws IOException {
            File f;
            if (!this.resource.getProtocol().equals("file")) {
                throw new IllegalStateException("can't set message when resource bundle is not loaded from a file. It was loaded from " + this.resource);
            }
            try {
                f = new File(this.resource.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(this.resource.getPath());
            }
            DefaultMutableMessages.updateProperties(f, this.charset, (ImmutableMap<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }
    }
}

