/*
 * Decompiled with CFR 0.152.
 */
package restx.i18n;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.inject.Named;
import restx.AppSettings;
import restx.factory.Module;
import restx.factory.Provides;
import restx.i18n.DefaultMessages;
import restx.i18n.DefaultMutableMessages;
import restx.i18n.Messages;
import restx.i18n.SupportedLocale;

@Module(priority=100)
public class I18nModule {
    @Named(value="Messages")
    @Provides
    public Messages messages(AppSettings appSettings) {
        if ("prod".equals(appSettings.mode())) {
            return new DefaultMessages("labels", StandardCharsets.UTF_8);
        }
        return new DefaultMutableMessages("labels", StandardCharsets.UTF_8);
    }

    @Named(value="ROOT")
    @Provides
    public SupportedLocale rootSupportedLocale() {
        return new SupportedLocale(Locale.ROOT);
    }

    @Named(value="restx.i18n.labelsJsTemplate")
    @Provides
    public String labelsJsTemplate() {
        return "// RESTX Labels - customize this with restx.i18n.labelsJsTemplate named String\nwindow.labels = {LABELS};";
    }
}

