/*
 * Decompiled with CFR 0.152.
 */
package restx.i18n;

import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.inject.Named;
import restx.RestxContext;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.StdRestxRequestMatcher;
import restx.StdRoute;
import restx.factory.Component;
import restx.http.CacheControl;
import restx.http.CurrentLocaleResolver;
import restx.http.ETag;
import restx.http.HttpStatus;
import restx.i18n.Messages;

@Component
public class MessagesRouter
extends RestxRouter {
    public MessagesRouter(@Named(value="Messages") Messages messages, @Named(value="restx.i18n.labelsJsTemplate") String labelsJsTemplate, @Named(value="CurrentLocaleResolver") CurrentLocaleResolver currentLocaleResolver) {
        super("MessagesRouter", new RestxRoute[]{new JsonLabelsRoute(messages, currentLocaleResolver), new JsLabelsRoute(messages, labelsJsTemplate, currentLocaleResolver)});
    }

    protected static void handleETagFor(RestxRequest req, RestxResponse resp, Iterable<Map.Entry<String, String>> entries) {
        Hasher hasher = Hashing.sha1().newHasher();
        for (Map.Entry<String, String> entry : entries) {
            hasher.putString((CharSequence)entry.getKey(), Charsets.UTF_8).putString((CharSequence)entry.getValue(), Charsets.UTF_8);
        }
        new ETag(hasher.hash().toString(), CacheControl.MUST_REVALIDATE).handleIn(req, resp);
    }

    protected static void writeLabelsJson(PrintWriter writer, Iterable<Map.Entry<String, String>> labels) {
        writer.print("{\n");
        boolean firstKey = true;
        for (Map.Entry<String, String> entry : labels) {
            if (firstKey) {
                firstKey = false;
            } else {
                writer.print(",\n");
            }
            writer.print(String.format("  \"%s\" : \"%s\"", entry.getKey(), MessagesRouter.escape(entry.getValue())));
        }
        writer.print("\n}");
    }

    private static String escape(String str) {
        return str.replace("\"", "\\\"").replace("\n", "\\n");
    }

    private static class JsonLabelsRoute
    extends StdRoute {
        private final Messages messages;
        private CurrentLocaleResolver currentLocaleResolver;

        public JsonLabelsRoute(Messages messages, CurrentLocaleResolver currentLocaleResolver) {
            super("labels.json", (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/i18n/labels.json"));
            this.messages = messages;
            this.currentLocaleResolver = currentLocaleResolver;
        }

        public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
            Iterable<Map.Entry<String, String>> entries = this.messages.entries(this.currentLocaleResolver.guessLocale(req));
            MessagesRouter.handleETagFor(req, resp, entries);
            resp.setStatus(HttpStatus.OK);
            resp.setContentType("application/json");
            PrintWriter writer = resp.getWriter();
            MessagesRouter.writeLabelsJson(writer, entries);
        }
    }

    private static class JsLabelsRoute
    extends StdRoute {
        private final Messages messages;
        private final CurrentLocaleResolver currentLocaleResolver;
        private final String labelsJsBefore;
        private final String labelsJsAfter;

        public JsLabelsRoute(Messages messages, String labelsJsTemplate, CurrentLocaleResolver currentLocaleResolver) {
            super("labels.js", (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/i18n/labels.js"));
            this.messages = messages;
            this.currentLocaleResolver = currentLocaleResolver;
            int i = labelsJsTemplate.indexOf("{LABELS}");
            if (i == -1) {
                throw new IllegalArgumentException("invalid labels js template. It must have {LABELS} token inside.\n\tIt was :'" + labelsJsTemplate + "'");
            }
            this.labelsJsBefore = labelsJsTemplate.substring(0, i);
            this.labelsJsAfter = labelsJsTemplate.substring(i + "{LABELS}".length());
        }

        public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
            Iterable<Map.Entry<String, String>> entries = this.messages.entries(this.currentLocaleResolver.guessLocale(req));
            MessagesRouter.handleETagFor(req, resp, entries);
            resp.setStatus(HttpStatus.OK);
            resp.setContentType("application/javascript");
            PrintWriter writer = resp.getWriter();
            writer.print(this.labelsJsBefore);
            MessagesRouter.writeLabelsJson(writer, entries);
            writer.print(this.labelsJsAfter);
        }
    }
}

