/*
 * Decompiled with CFR 0.152.
 */
package restx.log.admin;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import restx.annotations.GET;
import restx.annotations.PUT;
import restx.annotations.RestxResource;
import restx.factory.Component;
import restx.security.RolesAllowed;

@RestxResource(group="restx-admin")
@Component
public class LogAdminResource {
    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/logs")
    public String getLogs() {
        try {
            File appLog = new File(System.getProperty("logs.base", "logs"), "app.log");
            Object logs = Files.toString((File)appLog, (Charset)Charsets.UTF_8);
            int limit = 30000;
            if (((String)logs).length() > limit) {
                int length = ((String)logs).length();
                logs = ((String)logs).substring(((String)logs).length() - limit);
                logs = ((String)logs).substring(((String)logs).indexOf(10) + 1);
                logs = "[... " + (length - ((String)logs).length()) / 1024 + " kB truncated ...]\n" + (String)logs;
            }
            logs = "LOGS FROM: " + appLog.getAbsolutePath() + "\n------------------------------------------------------------------------------------------------\n" + (String)logs;
            return logs;
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/loggers")
    public Iterable<Logger> getLoggers() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)loggerFactory;
            ArrayList<Logger> loggers = new ArrayList<Logger>();
            for (ch.qos.logback.classic.Logger l : context.getLoggerList()) {
                loggers.add(new Logger(l.getName(), l.getEffectiveLevel().toString()));
            }
            return loggers;
        }
        return Collections.emptyList();
    }

    @RolesAllowed(value={"restx-admin"})
    @PUT(value="/@/loggers/{name}")
    public Logger updateLogger(String name, Logger logger) {
        logger.name = name;
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)loggerFactory;
            context.getLogger(name).setLevel(Level.valueOf((String)logger.level));
        }
        return logger;
    }

    public static class Logger {
        public String name;
        public String level;

        public Logger() {
        }

        public Logger(String name, String level) {
            this.name = name;
            this.level = level;
        }
    }
}

