/*
 * Decompiled with CFR 0.152.
 */
package restx.log.admin;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.annotations.PUT;
import restx.common.TypeReference;
import restx.common.Types;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.log.admin.LogAdminResource;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;
import restx.validation.Validations;

@Component(priority=0)
public class LogAdminResourceRouter
extends RestxRouter {
    public LogAdminResourceRouter(final LogAdminResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, final Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "LogAdminResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, String>("restx-admin#LogAdminResource#getLogs", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(String.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/logs"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<String> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of((Object)resource.getLogs());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "string";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = String.class;
                operation.sourceLocation = "restx.log.admin.LogAdminResource#getLogs()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/logs";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, Iterable<LogAdminResource.Logger>>("restx-admin#LogAdminResource#getLoggers", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{LogAdminResource.Logger.class}), Optional.absent()), Endpoint.of((String)"GET", (String)"/@/loggers"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Iterable<LogAdminResource.Logger>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of(resource.getLoggers());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "LIST[Logger]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.log.admin.LogAdminResource.Logger";
                operation.outEntityType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{LogAdminResource.Logger.class});
                operation.sourceLocation = "restx.log.admin.LogAdminResource#getLoggers()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/loggers";
                    }
                }).build();
            }
        }, new StdEntityRoute<LogAdminResource.Logger, LogAdminResource.Logger>("restx-admin#LogAdminResource#updateLogger", readerRegistry.build(LogAdminResource.Logger.class, Optional.absent()), writerRegistry.build(LogAdminResource.Logger.class, Optional.absent()), Endpoint.of((String)"PUT", (String)"/@/loggers/{name}"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"name")}){

            protected Optional<LogAdminResource.Logger> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, LogAdminResource.Logger body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of((Object)resource.updateLogger((String)Validations.checkValid((Optional)validator, (Object)((String)Preconditions.checkNotNull((Object)((String)this.mapQueryObjectFromRequest(String.class, "name", request, match, EndpointParameterKind.PATH)), (Object)"PATH param <name> is required")), (Class[])new Class[0]), (LogAdminResource.Logger)Validations.checkValid((Optional)validator, (Object)((LogAdminResource.Logger)Preconditions.checkNotNull((Object)body, (Object)"body param <logger> is required")), (Class[])new Class[0])));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription name = new OperationParameterDescription();
                name.name = "name";
                name.paramType = OperationParameterDescription.ParamType.path;
                name.dataType = "string";
                name.schemaKey = "";
                name.required = true;
                operation.parameters.add(name);
                OperationParameterDescription logger = new OperationParameterDescription();
                logger.name = "logger";
                logger.paramType = OperationParameterDescription.ParamType.body;
                logger.dataType = "Logger";
                logger.schemaKey = "restx.log.admin.LogAdminResource.Logger";
                logger.required = true;
                operation.parameters.add(logger);
                operation.responseClass = "Logger";
                operation.inEntitySchemaKey = "restx.log.admin.LogAdminResource.Logger";
                operation.inEntityType = LogAdminResource.Logger.class;
                operation.outEntitySchemaKey = "restx.log.admin.LogAdminResource.Logger";
                operation.outEntityType = LogAdminResource.Logger.class;
                operation.sourceLocation = "restx.log.admin.LogAdminResource#updateLogger(java.lang.String,restx.log.admin.LogAdminResource.Logger)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new PUT(){

                    public Class<PUT> annotationType() {
                        return PUT.class;
                    }

                    public String value() {
                        return "/@/loggers/{name}";
                    }
                }).build();
            }
        }});
    }
}

