/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import javax.inject.Named;
import restx.factory.Module;
import restx.factory.Provides;
import restx.security.BasicPrincipalAuthenticator;
import restx.security.DefaultSessionDefinitionEntry;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;

@Module(priority=10000)
public class BasicSecurityModule {
    @Named(value="principal")
    @Provides
    public RestxSession.Definition.Entry principalSessionEntry(final BasicPrincipalAuthenticator authenticator) {
        return new DefaultSessionDefinitionEntry(RestxPrincipal.class, "principal", (Function)new Function<String, Optional<? extends RestxPrincipal>>(){

            public Optional<? extends RestxPrincipal> apply(String key) {
                return authenticator.findByName(key);
            }
        });
    }

    @Named(value="sessionKey")
    @Provides
    public RestxSession.Definition.Entry sessionKeySessionEntry() {
        return new DefaultSessionDefinitionEntry(String.class, "sessionKey", (Function)new Function<String, Optional<? extends String>>(){

            public Optional<? extends String> apply(String key) {
                return Optional.fromNullable((Object)key);
            }
        });
    }
}

