/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.common.Types;
import restx.security.RestxPrincipal;
import restx.security.UserRepository;

public class FileBasedUserRepository<U extends RestxPrincipal>
implements UserRepository<U> {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedUserRepository.class);
    private final Class<U> userClass;
    private final U defaultAdmin;
    private final CachedData<String> credentials;
    private final CachedData<U> users;

    public FileBasedUserRepository(Class<U> userClass, ObjectMapper mapper, U defaultAdmin, Path usersPath, Path credentialsPath, boolean reloadOnChange) {
        this.userClass = userClass;
        this.defaultAdmin = defaultAdmin;
        this.credentials = new CachedData(credentialsPath, "credentials", mapper, Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, String.class}), reloadOnChange);
        this.users = new CachedData<U>(usersPath, "users", mapper, Types.newParameterizedType(List.class, (Type[])new Type[]{userClass}), reloadOnChange){

            @Override
            protected Map<String, U> toMap(Object o) {
                List users = (List)o;
                LinkedHashMap<String, RestxPrincipal> usersMap = new LinkedHashMap<String, RestxPrincipal>();
                for (RestxPrincipal user : users) {
                    usersMap.put(user.getName(), user);
                }
                return usersMap;
            }
        };
    }

    @Override
    public Optional<U> findUserByName(String name) {
        return this.users.get(name);
    }

    @Override
    public Optional<String> findCredentialByUserName(String userName) {
        return this.credentials.get(userName);
    }

    @Override
    public boolean isAdminDefined() {
        for (RestxPrincipal u : this.users.data().values()) {
            if (!u.getPrincipalRoles().contains((Object)"restx-admin")) continue;
            return true;
        }
        return false;
    }

    @Override
    public U defaultAdmin() {
        return this.defaultAdmin;
    }

    private static class CachedData<T> {
        private final Path dataPath;
        private final String name;
        private final ObjectReader reader;
        private final boolean reloadOnChange;
        private long dataFileTimestamp;
        private Map<String, T> data;

        public CachedData(Path path, String name, ObjectMapper mapper, ParameterizedType valueType, boolean reloadOnChange) {
            this.dataPath = path;
            this.name = name;
            this.reader = mapper.reader().withType((Type)valueType);
            this.reloadOnChange = reloadOnChange;
        }

        public Optional<T> get(String name) {
            return Optional.fromNullable(this.data().get(name));
        }

        private synchronized Map<String, T> data() {
            if (this.data == null || this.reloadOnChange) {
                if (!this.dataPath.toFile().exists()) {
                    logger.warn(this.name + " file " + this.dataPath.toAbsolutePath() + " not found");
                    if (this.data == null) {
                        this.data = new HashMap<String, T>();
                    }
                } else if (this.dataFileTimestamp >= this.dataPath.toFile().lastModified()) {
                    logger.debug(this.name + " are up to date");
                } else {
                    logger.debug("loading " + this.name + " from " + this.dataPath.toAbsolutePath());
                    try {
                        long lastModified = this.dataPath.toFile().lastModified();
                        this.data = this.toMap(this.reader.readValue(this.dataPath.toFile()));
                        this.dataFileTimestamp = lastModified;
                    }
                    catch (IOException e) {
                        logger.warn("error while loading " + this.name + " file " + this.dataPath + ": " + e.getMessage(), (Throwable)e);
                        this.data = new HashMap<String, T>();
                    }
                }
            }
            return this.data;
        }

        protected Map<String, T> toMap(Object o) {
            return (Map)o;
        }
    }
}

