/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxContext;
import restx.RestxFilter;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.StdRestxRequestMatch;
import restx.WebException;
import restx.factory.Component;
import restx.http.HttpStatus;
import restx.security.BasicPrincipalAuthenticator;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;

@Component(priority=-190)
public class HttpAuthenticationFilter
implements RestxFilter {
    private static final Logger logger = LoggerFactory.getLogger(HttpAuthenticationFilter.class);
    private HttpBasicAuthHandler basicHandler;

    public HttpAuthenticationFilter(HttpBasicAuthHandler basicHandler) {
        this.basicHandler = basicHandler;
    }

    public Optional<RestxHandlerMatch> match(RestxRequest req) {
        Optional authorization = req.getHeader("Authorization");
        if (authorization.isPresent()) {
            if (((String)authorization.get()).toLowerCase(Locale.ENGLISH).startsWith("basic ")) {
                return Optional.of((Object)new RestxHandlerMatch((RestxRequestMatch)new StdRestxRequestMatch("*", req.getRestxPath()), (RestxHandler)this.basicHandler));
            }
            logger.warn("unsupported authentication type: " + (String)authorization.get());
        }
        return Optional.absent();
    }

    public String toString() {
        return "HttpAuthenticationFilter";
    }

    @Component
    public static class HttpBasicAuthHandler
    implements RestxHandler {
        private final BasicPrincipalAuthenticator authenticator;

        public HttpBasicAuthHandler(BasicPrincipalAuthenticator authenticator) {
            this.authenticator = authenticator;
        }

        public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
            String pwd;
            String base64Pwd = ((String)req.getHeader("Authorization").get()).substring("basic ".length());
            String auth = new String(BaseEncoding.base64().decode((CharSequence)base64Pwd), Charsets.UTF_8);
            int i = auth.indexOf(58);
            if (i < 0) {
                throw new WebException(HttpStatus.BAD_REQUEST, "Invalid Basic Authentication. It must have the form <user>:<pwd>. It was: " + auth);
            }
            String u = auth.substring(0, i);
            Optional<? extends RestxPrincipal> principal = this.authenticator.authenticate(u, pwd = auth.substring(i + 1), ImmutableMap.of());
            if (!principal.isPresent()) {
                throw new WebException(HttpStatus.UNAUTHORIZED);
            }
            logger.debug("http basic authenticated '{}'", (Object)((RestxPrincipal)principal.get()).getName());
            RestxSession.current().authenticateAs((RestxPrincipal)principal.get());
            ctx.nextHandlerMatch().handle(req, resp, ctx);
        }

        public String toString() {
            return "HttpBasicAuthHandler";
        }
    }
}

