/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Map;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.Status;
import restx.annotations.DELETE;
import restx.annotations.GET;
import restx.annotations.POST;
import restx.common.TypeReference;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.security.PermissionFactory;
import restx.security.PermitAll;
import restx.security.RestxSecurityManager;
import restx.security.Session;
import restx.security.SessionResource;
import restx.validation.Validations;

@Component(priority=10000)
public class SessionResourceRouter
extends RestxRouter {
    public SessionResourceRouter(final SessionResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, final Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("default", "SessionResourceRouter", new RestxRoute[]{new StdEntityRoute<Map, Session>("default#SessionResource#authenticate", readerRegistry.build(Map.class, Optional.absent()), writerRegistry.build(Session.class, Optional.absent()), Endpoint.of((String)"POST", (String)"/sessions"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Session> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Map body) throws IOException {
                securityManager.check(request, match, this.open());
                try {
                    return Optional.of((Object)resource.authenticate((Map)Validations.checkValid((Optional)validator, (Object)((Map)Preconditions.checkNotNull((Object)body, (Object)"body param <session> is required")), (Class[])new Class[0])));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription session = new OperationParameterDescription();
                session.name = "session";
                session.paramType = OperationParameterDescription.ParamType.body;
                session.dataType = "MAP";
                session.schemaKey = "";
                session.required = true;
                operation.parameters.add(session);
                operation.responseClass = "Session";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Map.class;
                operation.outEntitySchemaKey = "restx.security.Session";
                operation.outEntityType = Session.class;
                operation.sourceLocation = "restx.security.SessionResource#authenticate(java.util.Map)";
                operation.annotations = ImmutableList.builder().add((Object)new PermitAll(){

                    public Class<PermitAll> annotationType() {
                        return PermitAll.class;
                    }
                }).add((Object)new POST(){

                    public Class<POST> annotationType() {
                        return POST.class;
                    }

                    public String value() {
                        return "/sessions";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, Session>("default#SessionResource#currentSession", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(Session.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/sessions/current"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Session> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.isAuthenticated());
                try {
                    return resource.currentSession();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "Session";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.security.Session";
                operation.outEntityType = Session.class;
                operation.sourceLocation = "restx.security.SessionResource#currentSession()";
                operation.annotations = ImmutableList.builder().add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/sessions/current";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, Status>("default#SessionResource#logout", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(Status.class, Optional.absent()), Endpoint.of((String)"DELETE", (String)"/sessions/{sessionKey}"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"sessionKey")}){

            protected Optional<Status> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.open());
                try {
                    return Optional.of((Object)resource.logout((String)Validations.checkValid((Optional)validator, (Object)((String)Preconditions.checkNotNull((Object)((String)this.mapQueryObjectFromRequest(String.class, "sessionKey", request, match, EndpointParameterKind.PATH)), (Object)"PATH param <sessionKey> is required")), (Class[])new Class[0])));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription sessionKey = new OperationParameterDescription();
                sessionKey.name = "sessionKey";
                sessionKey.paramType = OperationParameterDescription.ParamType.path;
                sessionKey.dataType = "string";
                sessionKey.schemaKey = "";
                sessionKey.required = true;
                operation.parameters.add(sessionKey);
                operation.responseClass = "Status";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.Status";
                operation.outEntityType = Status.class;
                operation.sourceLocation = "restx.security.SessionResource#logout(java.lang.String)";
                operation.annotations = ImmutableList.builder().add((Object)new PermitAll(){

                    public Class<PermitAll> annotationType() {
                        return PermitAll.class;
                    }
                }).add((Object)new DELETE(){

                    public Class<DELETE> annotationType() {
                        return DELETE.class;
                    }

                    public String value() {
                        return "/sessions/{sessionKey}";
                    }
                }).build();
            }
        }});
    }
}

