/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import org.joda.time.Duration;
import restx.security.BasicPrincipalAuthenticator;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;
import restx.security.SecuritySettings;
import restx.security.UserService;

public class StdBasicPrincipalAuthenticator
implements BasicPrincipalAuthenticator {
    private final UserService<?> users;
    private final SecuritySettings securitySettings;

    public StdBasicPrincipalAuthenticator(UserService<?> users, SecuritySettings securitySettings) {
        this.users = users;
        this.securitySettings = securitySettings;
    }

    @Override
    public Optional<? extends RestxPrincipal> findByName(String name) {
        return this.users.findUserByName(name);
    }

    @Override
    public Optional<? extends RestxPrincipal> authenticate(String name, String passwordHash, ImmutableMap<String, ?> principalData) {
        boolean rememberMe = Boolean.valueOf((String)principalData.get((Object)"rememberMe"));
        Optional<?> u = this.users.findAndCheckCredentials(name, passwordHash);
        if (u.isPresent()) {
            RestxSession.current().expires(rememberMe ? Duration.standardDays((long)this.securitySettings.rememberMeDuration()) : Duration.ZERO);
        }
        return u;
    }
}

