/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import restx.security.CredentialsStrategy;
import restx.security.RestxPrincipal;
import restx.security.UserRepository;
import restx.security.UserService;

public class StdUserService<U extends RestxPrincipal>
implements UserService<U> {
    private final UserRepository<U> repository;
    private final CredentialsStrategy checker;
    private final String defaultAdminPasswordHash;

    public StdUserService(UserRepository<U> repository, CredentialsStrategy checker, String defaultAdminPasswordHash) {
        this.repository = (UserRepository)Preconditions.checkNotNull(repository);
        this.checker = (CredentialsStrategy)Preconditions.checkNotNull((Object)checker);
        this.defaultAdminPasswordHash = (String)Preconditions.checkNotNull((Object)defaultAdminPasswordHash);
    }

    @Override
    public Optional<U> findUserByName(String name) {
        U defaultAdmin;
        Optional<U> user = this.repository.findUserByName(name);
        if (!user.isPresent() && (defaultAdmin = this.repository.defaultAdmin()).getName().equals(name) && !this.repository.isAdminDefined()) {
            return Optional.of(defaultAdmin);
        }
        return user;
    }

    @Override
    public Optional<U> findAndCheckCredentials(String name, String passwordHash) {
        Optional<U> user = this.findUserByName(name);
        if (!user.isPresent()) {
            return Optional.absent();
        }
        Optional<String> credential = this.repository.findCredentialByUserName(name);
        if (!credential.isPresent()) {
            if (this.repository.defaultAdmin() == user.get() && this.defaultAdminPasswordHash.equals(passwordHash)) {
                return user;
            }
            return Optional.absent();
        }
        if (this.checker.checkCredentials(name, passwordHash, (String)credential.get())) {
            return user;
        }
        return Optional.absent();
    }
}

