/*
 * Decompiled with CFR 0.152.
 */
package restx.servlet;

import com.google.common.base.Optional;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.JaninoRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxMainRouterFactory;
import restx.factory.Factory;
import restx.server.WebServer;
import restx.server.WebServers;
import restx.servlet.AbstractRestxMainRouterServlet;
import restx.servlet.RegisteredServerType;

public class RestxMainRouterServlet
extends AbstractRestxMainRouterServlet {
    public static final String DEPLOYED_SERVER_ID = "SERVLET-ENGINE-1";
    private static final Logger logger = LoggerFactory.getLogger(RestxMainRouterServlet.class);
    private String serverId;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Optional baseUri = Optional.fromNullable((Object)System.getProperty("restx.baseUri"));
        String baseServer = config.getServletContext().getInitParameter("restx.baseServerUri");
        if (!baseUri.isPresent() && baseServer != null) {
            try {
                Collection<String> mappings = this.getMappings(config);
                if (!mappings.isEmpty()) {
                    String routerPath = mappings.iterator().next();
                    if (routerPath.endsWith("/*")) {
                        routerPath = routerPath.substring(0, routerPath.length() - 2);
                    }
                    baseUri = Optional.of((Object)(baseServer + routerPath));
                    logger.debug("deduced baseUri from servlet registration: {}", (Object)baseUri);
                }
            }
            catch (JaninoRuntimeException e) {
                logger.info("servlet <3 detected. use servlet3+ to get automatic baseUri detection");
            }
            catch (CompileException e) {
                logger.info("servlet <3 detected. use servlet3+ to get automatic baseUri detection");
            }
            catch (InvocationTargetException e) {
                logger.info("servlet <3 detected. use servlet3+ to get automatic baseUri detection");
            }
        }
        if (!baseUri.isPresent()) {
            if (baseServer == null) {
                logger.debug("MINOR: baseUri cannot be found. Define it in restx.baseUri system property\nNote that is has no effect on restx behavior, it's just that it won't be able to properly display the startup banner.");
            } else {
                logger.info("MINOR: baseUri cannot be found. Define it in restx.baseUri system property, or use Servlet 3+ API\nNote that is has no effect on restx behavior, it's just that it won't be able to properly display the startup banner.");
            }
        }
        this.serverId = (String)Optional.fromNullable((Object)config.getServletContext().getInitParameter("restx.serverId")).or((Object)DEPLOYED_SERVER_ID);
        RestxMainRouterServlet.registerIdNeeded(this.serverId);
        this.init(RestxMainRouterFactory.newInstance((String)this.serverId, (Optional)baseUri));
    }

    protected Collection<String> getMappings(ServletConfig config) throws CompileException, InvocationTargetException {
        ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator("config.getServletContext().getServletRegistration(config.getServletName()).getMappings()", Collection.class, new String[]{"config"}, new Class[]{ServletConfig.class});
        return (Collection)expressionEvaluator.evaluate(new Object[]{config});
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.serverId != null) {
            RestxMainRouterFactory.clear((String)this.serverId);
        }
    }

    private static synchronized void registerIdNeeded(String serverId) {
        Optional serverById = WebServers.getServerById((String)serverId);
        if (!serverById.isPresent()) {
            WebServers.register((WebServer)new DeployedWebServer(serverId, RestxMainRouterServlet.guessServerType()));
        }
    }

    private static String guessServerType() {
        try {
            Set serverTypes = Factory.getInstance().getComponents(RegisteredServerType.class);
            for (StackTraceElement stackTraceElement : new Exception().fillInStackTrace().getStackTrace()) {
                for (RegisteredServerType registeredServerType : serverTypes) {
                    if (!stackTraceElement.getClassName().startsWith(registeredServerType.getPackageName())) continue;
                    return registeredServerType.getServerType();
                }
            }
            return "unknown";
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    private static class DeployedWebServer
    implements WebServer {
        private final String serverId;
        private final String serverType;

        private DeployedWebServer(String serverId, String serverType) {
            this.serverId = serverId;
            this.serverType = serverType;
        }

        public void start() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void startAndAwait() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void await() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void stop() throws Exception {
            throw new UnsupportedOperationException();
        }

        public boolean isStarted() {
            return true;
        }

        public String baseUrl() {
            return System.getProperty("restx.server.baseUrl", "");
        }

        public String getServerId() {
            return this.serverId;
        }

        public int getPort() {
            return 0;
        }

        public String getServerType() {
            return this.serverType;
        }
    }
}

