/*
 * Decompiled with CFR 0.152.
 */
package restx.servlet;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import javax.inject.Named;
import restx.common.Version;
import restx.factory.Module;
import restx.factory.Provides;
import restx.security.RestxPrincipal;
import restx.servlet.RegisteredServerType;
import restx.servlet.ServletPrincipalConverter;

@Module(priority=200)
public class ServletModule {
    public static final String SERVLET_PRINCIPAL_CONVERTER = "ServletPrincipalConverter";

    @Named(value="ServletPrincipalConverter")
    @Provides
    public ServletPrincipalConverter defaultServletPrincipalConverter() {
        return new ServletPrincipalConverter(){

            @Override
            public RestxPrincipal toRestxPrincipal(final Principal principal) {
                return new RestxPrincipal(){

                    public ImmutableSet<String> getPrincipalRoles() {
                        return ImmutableSet.of();
                    }

                    public String getName() {
                        return principal.getName();
                    }
                };
            }
        };
    }

    @Provides
    public RegisteredServerType jettyServerType() {
        return new RegisteredServerType("Jetty " + Version.getVersion((String)"org.eclipse.jetty", (String)"jetty-server"), "org.eclipse.jetty");
    }

    @Provides
    public RegisteredServerType tomcatServerType() {
        return new RegisteredServerType("Apache Tomcat " + Version.getVersion((String)"org.apache.tomcat", (String)"tomcat-catalina"), "org.eclipse.jetty");
    }
}

