/*
 * Decompiled with CFR 0.152.
 */
package restx.servlet.multipart;

import jakarta.servlet.http.Part;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxContext;
import restx.RestxRequest;
import restx.WebException;
import restx.entity.EntityRequestBodyReader;
import restx.http.HttpStatus;
import restx.servlet.HttpServletRestxRequest;
import restx.servlet.multipart.MultipartFormDataContentTypeModule;

public class FormDataEntityRequestBodyReader
implements EntityRequestBodyReader<Collection<Part>> {
    private static final Logger logger = LoggerFactory.getLogger(FormDataEntityRequestBodyReader.class);

    public Type getType() {
        return MultipartFormDataContentTypeModule.TYPE;
    }

    public Collection<Part> readBody(RestxRequest req, RestxContext ctx) throws IOException {
        try {
            return ((HttpServletRestxRequest)req).getParts();
        }
        catch (Exception e) {
            logger.error("Can't parse request", (Throwable)e);
            throw new WebException(HttpStatus.BAD_REQUEST, String.format("Can't parse request\n%s", e));
        }
    }
}

