/*
 * Decompiled with CFR 0.152.
 */
package restx.servlet.multipart;

import com.google.common.base.Optional;
import jakarta.servlet.http.Part;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.common.TypeReference;
import restx.entity.EntityDefaultContentTypeProvider;
import restx.entity.EntityRequestBodyReaderFactory;
import restx.factory.Module;
import restx.factory.Provides;
import restx.servlet.multipart.FormDataEntityRequestBodyReader;

@Module
public class MultipartFormDataContentTypeModule {
    private static final Logger logger = LoggerFactory.getLogger(MultipartFormDataContentTypeModule.class);
    public static final String FORM_DATA_CONTENT_TYPE = "multipart/form-data";
    public static final Type TYPE = new TypeReference<Collection<Part>>(){}.getType();

    @Provides
    public EntityDefaultContentTypeProvider formDataDefaultContentTypeProvider() {
        return new EntityDefaultContentTypeProvider(){

            public Optional<String> mayProvideDefaultContentType(Type type) {
                if (TYPE.equals(type)) {
                    return Optional.of((Object)MultipartFormDataContentTypeModule.FORM_DATA_CONTENT_TYPE);
                }
                return Optional.absent();
            }
        };
    }

    @Provides
    public EntityRequestBodyReaderFactory formDataRequestBodyReaderFactory() {
        return new EntityRequestBodyReaderFactory(){

            public Optional<FormDataEntityRequestBodyReader> mayBuildFor(Type valueType, String contentType) {
                if (!contentType.toLowerCase(Locale.ENGLISH).startsWith(MultipartFormDataContentTypeModule.FORM_DATA_CONTENT_TYPE)) {
                    return Optional.absent();
                }
                return Optional.of((Object)new FormDataEntityRequestBodyReader());
            }
        };
    }
}

