/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import restx.ResourcesRoute;
import restx.RestxContext;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.StdRestxRequestMatcher;
import restx.StdRoute;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecRecorder;

public class SpecRecorderRoute
extends RestxRouter {
    public SpecRecorderRoute(final RestxSpecRecorder.Repository recordedSpecsRepository, final RestxSpec.StorageSettings storageSettings, final RestxSecurityManager securityManager, final PermissionFactory permissionFactory) {
        super("SpecRecorderRouter", new RestxRoute[]{new ResourcesRoute("RecorderUIRoute", "/@/ui/recorder/", "restx.specs.recorder", ImmutableMap.of((Object)"", (Object)"index.html")), new StdRoute("RecorderRoute", (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/@/recorders")){

            public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                securityManager.check(req, match, permissionFactory.hasRole("restx-admin"));
                resp.setContentType("application/json");
                ArrayList data = Lists.newArrayList();
                for (RestxSpecRecorder.RecordedSpec spec : recordedSpecsRepository.getRecordedSpecs()) {
                    data.add(String.format("{ \"id\": \"%03d\", \"method\": \"%s\", \"path\": \"%s\", \"recordTime\": \"%s\", \"duration\": %d, \"capturedItems\": %d, \"capturedRequestSize\": %d, \"capturedResponseSize\": %d }", spec.getId(), spec.getMethod(), spec.getPath(), spec.getRecordTime(), spec.getDuration().getMillis(), spec.getCapturedItems(), spec.getCapturedRequestSize(), spec.getCapturedResponseSize()));
                }
                resp.getWriter().print("[\n");
                Joiner.on((String)",\n").appendTo((Appendable)resp.getWriter(), (Iterable)data);
                resp.getWriter().print("\n]");
            }
        }, new StdRoute("RecorderRecord", (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/@/recorders/{id}")){

            public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                securityManager.check(req, match, permissionFactory.hasRole("restx-admin"));
                int id = Integer.parseInt(match.getPathParam("id"));
                for (RestxSpecRecorder.RecordedSpec spec : recordedSpecsRepository.getRecordedSpecs()) {
                    if (spec.getId() != id) continue;
                    resp.setContentType("text/yaml");
                    resp.getWriter().println(spec.getSpec().toString());
                    return;
                }
                this.notFound(match, resp);
            }
        }, new StdRoute("RecorderRecordStorage", (RestxRequestMatcher)new StdRestxRequestMatcher("POST", "/@/recorders/storage/{id}")){

            public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                securityManager.check(req, match, permissionFactory.hasRole("restx-admin"));
                int id = Integer.parseInt(match.getPathParam("id"));
                for (RestxSpecRecorder.RecordedSpec spec : recordedSpecsRepository.getRecordedSpecs()) {
                    if (spec.getId() != id) continue;
                    Optional path = req.getQueryParam("path");
                    Optional title = req.getQueryParam("title");
                    RestxSpec.Storage storage = RestxSpec.Storage.with((RestxSpec.StorageSettings)storageSettings);
                    File destFile = storage.store(spec.getSpec().withTitle(title).withPath(storage.buildPath(path, (String)title.or((Object)spec.getSpec().getTitle()))));
                    resp.setContentType("text/plain");
                    resp.getWriter().println(destFile.getAbsolutePath());
                    return;
                }
                this.notFound(match, resp);
            }
        }});
    }
}

