/*
 * Decompiled with CFR 0.152.
 */
package restx.tests;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import restx.factory.Factory;
import restx.server.WebServer;
import restx.server.WebServerSupplier;
import restx.server.WebServers;
import restx.tests.HttpTestClient;

public class RestxServerRule
implements TestRule {
    protected final WebServerSupplier webServerSupplier;
    protected WebServer server;
    private String mode = "test";

    public RestxServerRule() {
        this((WebServerSupplier)Factory.getInstance().getComponent(WebServerSupplier.class));
    }

    public RestxServerRule(WebServerSupplier webServerSupplier) {
        this.webServerSupplier = webServerSupplier;
    }

    public HttpTestClient client() {
        return HttpTestClient.withBaseUrl(this.server.baseUrl());
    }

    public String getMode() {
        return this.mode;
    }

    public RestxServerRule setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public void setup() throws Exception {
        System.out.println("starting server");
        this.server = this.webServerSupplier.newWebServer(WebServers.findAvailablePort());
        Factory.LocalMachines.contextLocal((String)this.server.getServerId()).set("restx.mode", (Object)this.getMode());
        this.afterServerCreated();
        this.server.start();
        this.afterServerStarted();
        System.out.println("server started");
    }

    public void tearDown() throws Exception {
        this.beforeServerStop();
        System.out.println("stopping server");
        this.server.stop();
        this.afterServerStop();
        System.out.println("DONE");
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RestxServerRule.this.setup();
                try {
                    statement.evaluate();
                }
                finally {
                    RestxServerRule.this.tearDown();
                }
            }
        };
    }

    public WebServer getServer() {
        return this.server;
    }

    protected void afterServerCreated() {
    }

    protected void afterServerStarted() {
    }

    protected void beforeServerStop() {
    }

    protected void afterServerStop() {
    }
}

