/*
 * Decompiled with CFR 0.152.
 */
package restx.stats;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;

public class RestxStats {
    private DateTime timestamp;
    private String appNameHash;
    private String machineId;
    private int port;
    private String server;
    private String os;
    private String java;
    private long heapSize;
    private String restxVersion;
    private String restxMode;
    private String dataAccessInfo;
    private long totalUptime;
    private long currentUptime;
    private Map<String, RequestStats> requestStats = new LinkedHashMap<String, RequestStats>();

    public String getStatsId() {
        return this.appNameHash + "--" + this.machineId + "--" + this.port + "--" + this.restxMode;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public String getAppNameHash() {
        return this.appNameHash;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public String getOs() {
        return this.os;
    }

    public String getJava() {
        return this.java;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public String getRestxVersion() {
        return this.restxVersion;
    }

    public String getRestxMode() {
        return this.restxMode;
    }

    public String getDataAccessInfo() {
        return this.dataAccessInfo;
    }

    public long getTotalUptime() {
        return this.totalUptime;
    }

    public long getCurrentUptime() {
        return this.currentUptime;
    }

    public Map<String, RequestStats> getRequestStats() {
        return this.requestStats;
    }

    public RestxStats setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public RestxStats setAppNameHash(String appNameHash) {
        this.appNameHash = appNameHash;
        return this;
    }

    public RestxStats setMachineId(String machineId) {
        this.machineId = machineId;
        return this;
    }

    public RestxStats setPort(int port) {
        this.port = port;
        return this;
    }

    public RestxStats setServer(String server) {
        this.server = server;
        return this;
    }

    public RestxStats setOs(String os) {
        this.os = os;
        return this;
    }

    public RestxStats setJava(String java) {
        this.java = java;
        return this;
    }

    public RestxStats setHeapSize(long heapSize) {
        this.heapSize = heapSize;
        return this;
    }

    public RestxStats setRestxVersion(String restxVersion) {
        this.restxVersion = restxVersion;
        return this;
    }

    public RestxStats setRestxMode(String restxMode) {
        this.restxMode = restxMode;
        return this;
    }

    public RestxStats setDataAccessInfo(String dataAccessInfo) {
        this.dataAccessInfo = dataAccessInfo;
        return this;
    }

    public RestxStats setTotalUptime(long totalUptime) {
        this.totalUptime = totalUptime;
        return this;
    }

    public RestxStats setCurrentUptime(long currentUptime) {
        this.currentUptime = currentUptime;
        return this;
    }

    public RestxStats setRequestStats(Map<String, RequestStats> requestStats) {
        this.requestStats = requestStats;
        return this;
    }

    public static class RequestStats {
        private String httpMethod;
        private AtomicLong requestsCount = new AtomicLong();
        private AtomicLong minDuration = new AtomicLong(999999999999999999L);
        private AtomicLong maxDuration = new AtomicLong();
        private AtomicLong totalDuration = new AtomicLong();

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public AtomicLong getRequestsCount() {
            return this.requestsCount;
        }

        public AtomicLong getMinDuration() {
            return this.minDuration;
        }

        public AtomicLong getMaxDuration() {
            return this.maxDuration;
        }

        public AtomicLong getTotalDuration() {
            return this.totalDuration;
        }

        public RequestStats setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public RequestStats setRequestsCount(AtomicLong requestsCount) {
            this.requestsCount = requestsCount;
            return this;
        }

        public RequestStats setMinDuration(AtomicLong minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public RequestStats setMaxDuration(AtomicLong maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public RequestStats setTotalDuration(AtomicLong totalDuration) {
            this.totalDuration = totalDuration;
            return this;
        }
    }
}

