/*
 * Decompiled with CFR 0.152.
 */
package restx.stats;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;
import restx.stats.RestxStats;
import restx.stats.RestxStatsResource;

@Component(priority=0)
public class RestxStatsResourceRouter
extends RestxRouter {
    public RestxStatsResourceRouter(final RestxStatsResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "RestxStatsResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, RestxStats>("restx-admin#RestxStatsResource#getRestxStats", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(RestxStats.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/restx-stats"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<RestxStats> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of((Object)resource.getRestxStats());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "RestxStats";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.stats.RestxStats";
                operation.outEntityType = RestxStats.class;
                operation.sourceLocation = "restx.stats.RestxStatsResource#getRestxStats()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/restx-stats";
                    }
                }).build();
            }
        }});
    }
}

