/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.BrokerFrame;
import io.rsocket.broker.frames.BrokerInfoFlyweight;
import io.rsocket.broker.frames.FrameType;
import java.util.Objects;
import java.util.StringJoiner;

public final class BrokerInfo
extends BrokerFrame {
    private final Id brokerId;
    private final long timestamp;
    private final Tags tags;

    private BrokerInfo(Id brokerId, long timestamp, Tags tags) {
        super(FrameType.BROKER_INFO, 0);
        this.brokerId = brokerId;
        this.timestamp = timestamp;
        this.tags = tags;
    }

    public Id getBrokerId() {
        return this.brokerId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerInfo that = (BrokerInfo)o;
        return Objects.equals(this.brokerId, that.brokerId) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.tags);
    }

    public String toString() {
        return new StringJoiner(", ", BrokerInfo.class.getSimpleName() + "[", "]").add("brokerId=" + this.brokerId).add("timestamp=" + this.timestamp).add("tags=" + this.tags).toString();
    }

    public static Builder from(Id brokerId) {
        return new Builder(brokerId);
    }

    public static BrokerInfo from(ByteBuf byteBuf) {
        return ((Builder)BrokerInfo.from(BrokerInfoFlyweight.brokerId(byteBuf)).timestamp(BrokerInfoFlyweight.timestamp(byteBuf)).with(BrokerInfoFlyweight.tags(byteBuf))).build();
    }

    public static final class Builder
    extends Tags.Builder<Builder> {
        private final Id brokerId;
        private long timestamp = System.currentTimeMillis();

        private Builder(Id brokerId) {
            Objects.requireNonNull(brokerId, "brokerId may not be null");
            this.brokerId = brokerId;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public BrokerInfo build() {
            if (this.timestamp <= 0L) {
                throw new IllegalArgumentException("timestamp must be > 0");
            }
            return new BrokerInfo(this.brokerId, this.timestamp, this.buildTags());
        }
    }
}

