/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.BrokerFrame;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.RouteJoinFlyweight;
import java.util.Objects;
import java.util.StringJoiner;

public final class RouteJoin
extends BrokerFrame {
    private final Id brokerId;
    private final Id routeId;
    private final long timestamp;
    private final String serviceName;
    private final Tags tags;

    public RouteJoin(Id brokerId, Id routeId, long timestamp, String serviceName, Tags tags) {
        super(FrameType.ROUTE_JOIN, 0);
        this.brokerId = brokerId;
        this.routeId = routeId;
        this.timestamp = timestamp;
        this.serviceName = serviceName;
        this.tags = tags;
    }

    public Id getBrokerId() {
        return this.brokerId;
    }

    public Id getRouteId() {
        return this.routeId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteJoin routeJoin = (RouteJoin)o;
        return this.timestamp == routeJoin.timestamp && Objects.equals(this.brokerId, routeJoin.brokerId) && Objects.equals(this.routeId, routeJoin.routeId) && Objects.equals(this.serviceName, routeJoin.serviceName) && Objects.equals(this.tags, routeJoin.tags);
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.routeId, this.timestamp, this.serviceName, this.tags);
    }

    public String toString() {
        return new StringJoiner(", ", RouteJoin.class.getSimpleName() + "[", "]").add("brokerId=" + this.brokerId).add("routeId=" + this.routeId).add("timestamp=" + this.timestamp).add("serviceName='" + this.serviceName + "'").add("tags=" + this.tags).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RouteJoin from(ByteBuf byteBuf) {
        return ((Builder)RouteJoin.builder().brokerId(RouteJoinFlyweight.brokerId(byteBuf)).routeId(RouteJoinFlyweight.routeId(byteBuf)).timestamp(RouteJoinFlyweight.timestamp(byteBuf)).serviceName(RouteJoinFlyweight.serviceName(byteBuf)).with(RouteJoinFlyweight.tags(byteBuf))).build();
    }

    public static final class Builder
    extends Tags.Builder<Builder> {
        private Id brokerId;
        private Id routeId;
        private long timestamp = System.currentTimeMillis();
        private String serviceName;

        public Builder brokerId(Id brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public Builder routeId(Id routeId) {
            this.routeId = routeId;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public RouteJoin build() {
            Objects.requireNonNull(this.brokerId, "brokerId may not be null");
            Objects.requireNonNull(this.routeId, "routeId may not be null");
            Objects.requireNonNull(this.serviceName, "serviceName may not be null");
            if (this.timestamp <= 0L) {
                throw new IllegalArgumentException("timestamp must be > 0");
            }
            return new RouteJoin(this.brokerId, this.routeId, this.timestamp, this.serviceName, this.buildTags());
        }
    }
}

