/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.FlyweightUtils;
import io.rsocket.broker.frames.FrameHeaderFlyweight;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.TagsFlyweight;
import java.util.Objects;

public class RouteJoinFlyweight {
    public static ByteBuf encode(ByteBufAllocator allocator, Id brokerId, Id routeId, long timestamp, String serviceName, Tags tags, int flags) {
        Objects.requireNonNull(brokerId, "brokerId may not be null");
        Objects.requireNonNull(routeId, "routeId may not be null");
        Objects.requireNonNull(serviceName, "serviceName may not be null");
        Objects.requireNonNull(tags, "tags may not be null");
        ByteBuf byteBuf = FrameHeaderFlyweight.encode(allocator, FrameType.ROUTE_JOIN, flags);
        FlyweightUtils.encodeId(byteBuf, brokerId);
        FlyweightUtils.encodeId(byteBuf, routeId);
        byteBuf.writeLong(timestamp);
        FlyweightUtils.encodeByteString(byteBuf, serviceName);
        TagsFlyweight.encode(byteBuf, tags);
        return byteBuf;
    }

    public static Id brokerId(ByteBuf byteBuf) {
        return FlyweightUtils.decodeId(byteBuf, 6);
    }

    public static Id routeId(ByteBuf byteBuf) {
        int offset = 22;
        return FlyweightUtils.decodeId(byteBuf, offset);
    }

    public static long timestamp(ByteBuf byteBuf) {
        int offset = 38;
        return byteBuf.getLong(offset);
    }

    public static String serviceName(ByteBuf byteBuf) {
        int offset = 46;
        return FlyweightUtils.decodeByteString(byteBuf, offset);
    }

    public static Tags tags(ByteBuf byteBuf) {
        int offset = 46;
        offset += FlyweightUtils.decodeByteStringLength(byteBuf, offset);
        return TagsFlyweight.decode(offset, byteBuf);
    }
}

