/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.BrokerFrame;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.RouteSetupFlyweight;
import java.util.Objects;
import java.util.StringJoiner;

public final class RouteSetup
extends BrokerFrame {
    private final Id routeId;
    private final String serviceName;
    private final Tags tags;

    private RouteSetup(Id routeId, String serviceName, Tags tags) {
        super(FrameType.ROUTE_SETUP, 0);
        this.routeId = routeId;
        this.serviceName = serviceName;
        this.tags = tags;
    }

    public Id getRouteId() {
        return this.routeId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Tags getTags() {
        return this.tags;
    }

    public String toString() {
        return new StringJoiner(", ", RouteSetup.class.getSimpleName() + "[", "]").add("routeId=" + this.routeId).add("serviceName='" + this.serviceName + "'").add("tags=" + this.tags).toString();
    }

    public static Builder from(Id id, String serviceName) {
        return new Builder(id, serviceName);
    }

    public static RouteSetup from(ByteBuf byteBuf) {
        return ((Builder)RouteSetup.from(RouteSetupFlyweight.routeId(byteBuf), RouteSetupFlyweight.serviceName(byteBuf)).with(RouteSetupFlyweight.tags(byteBuf))).build();
    }

    public static final class Builder
    extends Tags.Builder<Builder> {
        private final Id id;
        private final String serviceName;

        private Builder(Id id, String serviceName) {
            Objects.requireNonNull(id, "id may not be null");
            Objects.requireNonNull(serviceName, "serviceName may not be null");
            if (serviceName.isEmpty()) {
                throw new IllegalArgumentException("serviceName may not be empty");
            }
            this.id = id;
            this.serviceName = serviceName;
        }

        public RouteSetup build() {
            return new RouteSetup(this.id, this.serviceName, this.buildTags());
        }
    }
}

