/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.rsocket.broker.common.Key;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.common.WellKnownKey;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class TagsFlyweight {
    private static final int WELL_KNOWN_TAG = 128;
    private static final int HAS_MORE_TAGS = 128;
    private static final int MAX_TAG_LENGTH = 127;

    public static ByteBuf encode(ByteBuf byteBuf, Tags tags) {
        Objects.requireNonNull(byteBuf, "byteBuf may not be null");
        Iterator it = tags.asMap().entrySet().iterator();
        while (it.hasNext()) {
            int keyLength;
            Map.Entry entry = it.next();
            Key key = (Key)entry.getKey();
            if (key.getWellKnownKey() != null) {
                byte id = key.getWellKnownKey().getIdentifier();
                keyLength = 0x80 | id;
                byteBuf.writeByte(keyLength);
            } else {
                String keyString = key.getKey();
                if (keyString == null || (keyLength = ByteBufUtil.utf8Bytes((CharSequence)keyString)) == 0 || keyLength > 127) continue;
                byteBuf.writeByte(keyLength);
                ByteBufUtil.reserveAndWriteUtf8((ByteBuf)byteBuf, (CharSequence)keyString, (int)keyLength);
            }
            boolean hasMoreTags = it.hasNext();
            String value = (String)entry.getValue();
            int valueLength = ByteBufUtil.utf8Bytes((CharSequence)value);
            if (valueLength == 0 || valueLength > 127) continue;
            int valueByte = hasMoreTags ? 0x80 | valueLength : valueLength;
            byteBuf.writeByte(valueByte);
            ByteBufUtil.reserveAndWriteUtf8((ByteBuf)byteBuf, (CharSequence)value, (int)valueLength);
        }
        return byteBuf;
    }

    public static Tags decode(int offset, ByteBuf byteBuf) {
        Tags.Builder builder = Tags.builder();
        if (offset >= byteBuf.writerIndex()) {
            return builder.buildTags();
        }
        boolean hasMoreTags = true;
        while (hasMoreTags) {
            Key key;
            byte keyByte = byteBuf.getByte(offset);
            ++offset;
            boolean isWellKnownTag = (keyByte & 0x80) == 128;
            int keyLengthOrId = keyByte & 0x7F;
            if (isWellKnownTag) {
                WellKnownKey wellKnownKey = WellKnownKey.fromIdentifier((int)keyLengthOrId);
                key = Key.of((WellKnownKey)wellKnownKey);
            } else {
                String keyString = byteBuf.toString(offset, keyLengthOrId, StandardCharsets.UTF_8);
                offset += keyLengthOrId;
                key = Key.of((String)keyString);
            }
            byte valueByte = byteBuf.getByte(offset);
            hasMoreTags = (valueByte & 0x80) == 128;
            int valueLength = valueByte & 0x7F;
            String value = byteBuf.toString(++offset, valueLength, StandardCharsets.UTF_8);
            offset += valueLength;
            builder.with(key, value);
        }
        return builder.buildTags();
    }

    public static int length(int offset, ByteBuf byteBuf) {
        int originalOffset = offset;
        if (offset >= byteBuf.writerIndex()) {
            return 0;
        }
        boolean hasMoreTags = true;
        while (hasMoreTags) {
            boolean isWellKnownTag;
            byte keyByte = byteBuf.getByte(offset);
            ++offset;
            boolean bl = isWellKnownTag = (keyByte & 0x80) == 128;
            if (!isWellKnownTag) {
                int keyLength = keyByte & 0x7F;
                offset += keyLength;
            }
            byte valueByte = byteBuf.getByte(offset);
            ++offset;
            hasMoreTags = (valueByte & 0x80) == 128;
            int valueLength = valueByte & 0x7F;
            offset += valueLength;
        }
        return offset - originalOffset;
    }
}

