/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.query;

import io.netty.util.concurrent.FastThreadLocal;
import io.rsocket.RSocket;
import io.rsocket.broker.RSocketIndex;
import io.rsocket.broker.RoutingTable;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.BrokerInfo;
import io.rsocket.broker.frames.RouteJoin;
import io.rsocket.broker.query.RSocketQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class CombinedRSocketQuery
implements RSocketQuery {
    private static final FastThreadLocal<List<RSocket>> MEMBERS = new FastThreadLocal<List<RSocket>>(){

        protected List<RSocket> initialValue() {
            return new ArrayList<RSocket>();
        }
    };
    private static final FastThreadLocal<Set<Id>> FOUND = new FastThreadLocal<Set<Id>>(){

        protected Set<Id> initialValue() {
            return new HashSet<Id>();
        }
    };
    private final Id brokerId;
    private final RoutingTable routingTable;
    private final RSocketIndex rSocketIndex;
    private final Function<BrokerInfo, RSocket> brokerInfoRSocketMapper;

    public CombinedRSocketQuery(Id brokerId, RoutingTable routingTable, RSocketIndex rSocketIndex, Function<BrokerInfo, RSocket> brokerInfoRSocketMapper) {
        this.brokerId = brokerId;
        this.routingTable = routingTable;
        this.rSocketIndex = rSocketIndex;
        this.brokerInfoRSocketMapper = brokerInfoRSocketMapper;
    }

    @Override
    public List<RSocket> query(Tags tags) {
        if (tags == null || tags.isEmpty()) {
            throw new IllegalArgumentException("tags may not be empty");
        }
        List members = (List)MEMBERS.get();
        members.clear();
        List<RSocket> query = this.rSocketIndex.query(tags);
        if (query != null && !query.isEmpty()) {
            members.addAll(query);
        }
        Set found = (Set)FOUND.get();
        found.clear();
        for (RouteJoin routeJoin : this.routingTable.find(tags)) {
            Id joinedBrokerId = routeJoin.getBrokerId();
            if (Objects.equals(this.brokerId, joinedBrokerId) || found.contains(joinedBrokerId)) continue;
            found.add(joinedBrokerId);
            BrokerInfo brokerInfo = BrokerInfo.from((Id)joinedBrokerId).build();
            members.add(this.brokerInfoRSocketMapper.apply(brokerInfo));
        }
        return members;
    }
}

