/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.util;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

class Table<R, C, V> {
    final Map<R, Map<C, V>> backingMap;
    final Supplier<? extends Map<C, V>> factory;

    Table(Map<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        this.backingMap = backingMap;
        this.factory = factory;
    }

    public boolean contains(Object rowKey, Object columnKey) {
        return rowKey != null && columnKey != null && this.doContains(rowKey, columnKey);
    }

    public V get(Object rowKey, Object columnKey) {
        return rowKey == null || columnKey == null ? null : (V)this.doGet(rowKey, columnKey);
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public int size() {
        int size = 0;
        for (Map<C, V> map : this.backingMap.values()) {
            size += map.size();
        }
        return size;
    }

    public void clear() {
        this.backingMap.clear();
    }

    private Map<C, V> getOrCreate(R rowKey) {
        Map<C, V> map = this.backingMap.get(rowKey);
        if (map == null) {
            map = this.factory.get();
            this.backingMap.put(rowKey, map);
        }
        return map;
    }

    public V put(R rowKey, C columnKey, V value) {
        Objects.requireNonNull(rowKey);
        Objects.requireNonNull(columnKey);
        Objects.requireNonNull(value);
        return this.getOrCreate(rowKey).put(columnKey, value);
    }

    public V remove(Object rowKey, Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map<C, V> map = Table.safeGet(this.backingMap, rowKey);
        if (map == null) {
            return null;
        }
        V value = map.remove(columnKey);
        if (map.isEmpty()) {
            this.backingMap.remove(rowKey);
        }
        return value;
    }

    public Map<C, V> row(R rowKey) {
        return this.backingMap.get(rowKey);
    }

    public Map<R, Map<C, V>> rowMap() {
        return this.backingMap;
    }

    protected boolean doContains(Object rowKey, Object columnKey) {
        Map<C, V> row = Table.safeGet(this.rowMap(), rowKey);
        return row != null && Table.safeContainsKey(row, columnKey);
    }

    protected V doGet(Object rowKey, Object columnKey) {
        Map<C, V> row = Table.safeGet(this.rowMap(), rowKey);
        return row == null ? null : (V)Table.safeGet(row, columnKey);
    }

    public String toString() {
        return this.rowMap().toString();
    }

    static boolean safeContainsKey(Map<?, ?> map, Object key) {
        Objects.requireNonNull(map);
        try {
            return map.containsKey(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    static <V> V safeGet(Map<?, V> map, Object key) {
        Objects.requireNonNull(map);
        try {
            return map.get(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return null;
        }
    }

    static <V> V safeRemove(Map<?, V> map, Object key) {
        Objects.requireNonNull(map);
        try {
            return map.remove(key);
        }
        catch (ClassCastException | NullPointerException e) {
            return null;
        }
    }
}

