/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableMetadataFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class MetadataPushFrame
extends AbstractRecyclableMetadataFrame<MetadataPushFrame> {
    private static final int OFFSET_METADATA = 2;
    private static final Recycler<MetadataPushFrame> RECYCLER = RecyclerFactory.createRecycler(MetadataPushFrame::new);

    private MetadataPushFrame(Recycler.Handle<MetadataPushFrame> handle) {
        super(handle);
    }

    public static MetadataPushFrame createMetadataPushFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (MetadataPushFrame)((MetadataPushFrame)RECYCLER.get()).setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataPushFrame createMetadataPushFrame(ByteBufAllocator byteBufAllocator, String metadata) {
        ByteBuf metadataByteBuf = MetadataPushFrame.getUtf8AsByteBufRequired(metadata, "metadata must not be null");
        try {
            MetadataPushFrame metadataPushFrame = MetadataPushFrame.createMetadataPushFrame(byteBufAllocator, metadataByteBuf);
            return metadataPushFrame;
        }
        finally {
            ReferenceCountUtil.release((Object)metadataByteBuf);
        }
    }

    public static MetadataPushFrame createMetadataPushFrame(ByteBufAllocator byteBufAllocator, ByteBuf metadata) {
        Objects.requireNonNull(metadata, "metadata must not be null");
        ByteBuf byteBuf = MetadataPushFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.METADATA_PUSH);
        byteBuf = MetadataPushFrame.appendMetadata(byteBuf, metadata);
        return (MetadataPushFrame)((MetadataPushFrame)RECYCLER.get()).setByteBuf(byteBuf);
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(2);
    }

    public String toString() {
        return "MetadataPushFrame{metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + '}';
    }
}

