/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestChannelFrameCodec;
import io.rsocket.frame.RequestFireAndForgetFrameCodec;
import io.rsocket.frame.RequestResponseFrameCodec;
import io.rsocket.frame.RequestStreamFrameCodec;
import reactor.util.annotation.Nullable;

class FragmentationUtils {
    static final int MIN_MTU_SIZE = 64;
    static final int FRAME_OFFSET = 3 + FrameHeaderCodec.size();
    static final int FRAME_OFFSET_WITH_METADATA = FRAME_OFFSET + 3;
    static final int FRAME_OFFSET_WITH_INITIAL_REQUEST_N = FRAME_OFFSET + 4;
    static final int FRAME_OFFSET_WITH_METADATA_AND_INITIAL_REQUEST_N = FRAME_OFFSET_WITH_METADATA + 4;

    FragmentationUtils() {
    }

    static boolean isFragmentable(int mtu, ByteBuf data, @Nullable ByteBuf metadata, boolean hasInitialRequestN) {
        if (mtu == 0) {
            return false;
        }
        if (metadata != null) {
            int remaining = mtu - (hasInitialRequestN ? FRAME_OFFSET_WITH_METADATA_AND_INITIAL_REQUEST_N : FRAME_OFFSET_WITH_METADATA);
            return metadata.readableBytes() + data.readableBytes() > remaining;
        }
        int remaining = mtu - (hasInitialRequestN ? FRAME_OFFSET_WITH_INITIAL_REQUEST_N : FRAME_OFFSET);
        return data.readableBytes() > remaining;
    }

    static ByteBuf encodeFollowsFragment(ByteBufAllocator allocator, int mtu, int streamId, boolean complete, ByteBuf metadata, ByteBuf data) {
        int remaining = mtu - FRAME_OFFSET;
        ByteBuf metadataFragment = null;
        if (metadata.isReadable()) {
            int r = Math.min(remaining -= 3, metadata.readableBytes());
            remaining -= r;
            metadataFragment = metadata.readRetainedSlice(r);
        }
        ByteBuf dataFragment = Unpooled.EMPTY_BUFFER;
        try {
            if (remaining > 0 && data.isReadable()) {
                int r = Math.min(remaining, data.readableBytes());
                dataFragment = data.readRetainedSlice(r);
            }
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            if (metadataFragment != null) {
                metadataFragment.release();
            }
            throw e;
        }
        boolean follows = data.isReadable() || metadata.isReadable();
        return PayloadFrameCodec.encode(allocator, streamId, follows, !follows && complete, true, metadataFragment, dataFragment);
    }

    static ByteBuf encodeFirstFragment(ByteBufAllocator allocator, int mtu, FrameType frameType, int streamId, boolean hasMetadata, ByteBuf metadata, ByteBuf data) {
        ByteBuf metadataFragment;
        int remaining = mtu - FRAME_OFFSET;
        Object object = metadataFragment = hasMetadata ? Unpooled.EMPTY_BUFFER : null;
        if (hasMetadata) {
            remaining -= 3;
            if (metadata.isReadable()) {
                int r = Math.min(remaining, metadata.readableBytes());
                remaining -= r;
                metadataFragment = metadata.readRetainedSlice(r);
            }
        }
        ByteBuf dataFragment = Unpooled.EMPTY_BUFFER;
        try {
            if (remaining > 0 && data.isReadable()) {
                int r = Math.min(remaining, data.readableBytes());
                dataFragment = data.readRetainedSlice(r);
            }
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            if (metadataFragment != null) {
                metadataFragment.release();
            }
            throw e;
        }
        switch (frameType) {
            case REQUEST_FNF: {
                return RequestFireAndForgetFrameCodec.encode(allocator, streamId, true, metadataFragment, dataFragment);
            }
            case REQUEST_RESPONSE: {
                return RequestResponseFrameCodec.encode(allocator, streamId, true, metadataFragment, dataFragment);
            }
            case PAYLOAD: {
                return PayloadFrameCodec.encode(allocator, streamId, true, false, false, metadataFragment, dataFragment);
            }
            case NEXT: 
            case NEXT_COMPLETE: {
                return PayloadFrameCodec.encode(allocator, streamId, true, false, true, metadataFragment, dataFragment);
            }
        }
        throw new IllegalStateException("unsupported fragment type: " + (Object)((Object)frameType));
    }

    static ByteBuf encodeFirstFragment(ByteBufAllocator allocator, int mtu, long initialRequestN, FrameType frameType, int streamId, boolean hasMetadata, ByteBuf metadata, ByteBuf data) {
        ByteBuf metadataFragment;
        int remaining = mtu - FRAME_OFFSET_WITH_INITIAL_REQUEST_N;
        Object object = metadataFragment = hasMetadata ? Unpooled.EMPTY_BUFFER : null;
        if (hasMetadata) {
            remaining -= 3;
            if (metadata.isReadable()) {
                int r = Math.min(remaining, metadata.readableBytes());
                remaining -= r;
                metadataFragment = metadata.readRetainedSlice(r);
            }
        }
        ByteBuf dataFragment = Unpooled.EMPTY_BUFFER;
        try {
            if (remaining > 0 && data.isReadable()) {
                int r = Math.min(remaining, data.readableBytes());
                dataFragment = data.readRetainedSlice(r);
            }
        }
        catch (IllegalReferenceCountException | NullPointerException e) {
            if (metadataFragment != null) {
                metadataFragment.release();
            }
            throw e;
        }
        switch (frameType) {
            case REQUEST_STREAM: {
                return RequestStreamFrameCodec.encode(allocator, streamId, true, initialRequestN, metadataFragment, dataFragment);
            }
            case REQUEST_CHANNEL: {
                return RequestChannelFrameCodec.encode(allocator, streamId, true, false, initialRequestN, metadataFragment, dataFragment);
            }
        }
        throw new IllegalStateException("unsupported fragment type: " + (Object)((Object)frameType));
    }

    static int assertMtu(int mtu) {
        if (mtu > 0 && mtu < 64 || mtu < 0) {
            String msg = String.format("The smallest allowed mtu size is %d bytes, provided: %d", 64, mtu);
            throw new IllegalArgumentException(msg);
        }
        return mtu;
    }
}

