/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBufAllocator;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.rsocket.DuplexConnection;
import io.rsocket.RSocket;
import io.rsocket.core.FrameHandler;
import io.rsocket.core.RequesterLeaseTracker;
import io.rsocket.core.StreamIdSupplier;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.plugins.RequestInterceptor;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

class RequesterResponderSupport {
    private final int mtu;
    private final int maxFrameLength;
    private final int maxInboundPayloadSize;
    private final PayloadDecoder payloadDecoder;
    private final ByteBufAllocator allocator;
    private final DuplexConnection connection;
    @Nullable
    private final RequestInterceptor requestInterceptor;
    @Nullable
    final StreamIdSupplier streamIdSupplier;
    final IntObjectMap<FrameHandler> activeStreams = new IntObjectHashMap();

    public RequesterResponderSupport(int mtu, int maxFrameLength, int maxInboundPayloadSize, PayloadDecoder payloadDecoder, DuplexConnection connection, @Nullable StreamIdSupplier streamIdSupplier, Function<RSocket, ? extends RequestInterceptor> requestInterceptorFunction) {
        this.mtu = mtu;
        this.maxFrameLength = maxFrameLength;
        this.maxInboundPayloadSize = maxInboundPayloadSize;
        this.payloadDecoder = payloadDecoder;
        this.allocator = connection.alloc();
        this.streamIdSupplier = streamIdSupplier;
        this.connection = connection;
        this.requestInterceptor = requestInterceptorFunction.apply((RSocket)((Object)this));
    }

    public int getMtu() {
        return this.mtu;
    }

    public int getMaxFrameLength() {
        return this.maxFrameLength;
    }

    public int getMaxInboundPayloadSize() {
        return this.maxInboundPayloadSize;
    }

    public PayloadDecoder getPayloadDecoder() {
        return this.payloadDecoder;
    }

    public ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    public DuplexConnection getDuplexConnection() {
        return this.connection;
    }

    @Nullable
    public RequesterLeaseTracker getRequesterLeaseTracker() {
        return null;
    }

    @Nullable
    public RequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextStreamId() {
        StreamIdSupplier streamIdSupplier = this.streamIdSupplier;
        if (streamIdSupplier != null) {
            RequesterResponderSupport requesterResponderSupport = this;
            synchronized (requesterResponderSupport) {
                return streamIdSupplier.nextStreamId(this.activeStreams);
            }
        }
        throw new UnsupportedOperationException("Responder can not issue id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAndGetNextStreamId(FrameHandler frameHandler) {
        StreamIdSupplier streamIdSupplier = this.streamIdSupplier;
        if (streamIdSupplier != null) {
            IntObjectMap<FrameHandler> activeStreams = this.activeStreams;
            RequesterResponderSupport requesterResponderSupport = this;
            synchronized (requesterResponderSupport) {
                int streamId = streamIdSupplier.nextStreamId(activeStreams);
                activeStreams.put(streamId, (Object)frameHandler);
                return streamId;
            }
        }
        throw new UnsupportedOperationException("Responder can not issue id");
    }

    public synchronized boolean add(int streamId, FrameHandler frameHandler) {
        FrameHandler previousHandler = (FrameHandler)this.activeStreams.putIfAbsent((Object)streamId, (Object)frameHandler);
        return previousHandler == null;
    }

    @Nullable
    public synchronized FrameHandler get(int streamId) {
        return (FrameHandler)this.activeStreams.get(streamId);
    }

    public synchronized boolean remove(int streamId, FrameHandler frameHandler) {
        return this.activeStreams.remove((Object)streamId, (Object)frameHandler);
    }
}

